/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.constant;

import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.biz.credits.strategy.Impl.WandaApiStrategy;
import cn.com.duiba.constant.DelayNotifyConfig;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="wanda")
public class WandaConfig
implements InitializingBean {
    @Resource
    private WandaApiStrategy wandaApiStrategy;
    private Set<Long> appIdSet = Sets.newHashSet((Object[])new Long[]{1L});
    private String authStr = "";
    private Map<String, String> authParams = new HashMap<String, String>();
    private String queryTokenUrl = "https://platform.wandahotels.com/sso-auth/token";
    private String queryCreditsUrl = "https://platform-dev.wandahotels.com/crm-service/2b/point/getPointsByCardNo";
    private String defaultStoreCode;
    private Integer msgDelayLevel = 4;

    public Map<String, String> getAuthParams() {
        return this.authParams;
    }

    public void setAuthParams(Map<String, String> authParams) {
        this.authParams = authParams;
    }

    public Set<Long> getAppIdSet() {
        return this.appIdSet;
    }

    public void setAppIdSet(Set<Long> appIdSet) {
        this.appIdSet = appIdSet;
    }

    public String getQueryTokenUrl() {
        return this.queryTokenUrl;
    }

    public String getQueryCreditsUrl() {
        return this.queryCreditsUrl;
    }

    public void setQueryCreditsUrl(String queryCreditsUrl) {
        this.queryCreditsUrl = queryCreditsUrl;
    }

    public void setQueryTokenUrl(String queryTokenUrl) {
        this.queryTokenUrl = queryTokenUrl;
    }

    public String getAuthStr() {
        return this.authStr;
    }

    public void setAuthStr(String authStr) {
        this.authStr = authStr;
    }

    public String getDefaultStoreCode() {
        return this.defaultStoreCode;
    }

    public void setDefaultStoreCode(String defaultStoreCode) {
        this.defaultStoreCode = defaultStoreCode;
    }

    public Integer getMsgDelayLevel() {
        return this.msgDelayLevel;
    }

    public void setMsgDelayLevel(Integer msgDelayLevel) {
        this.msgDelayLevel = msgDelayLevel;
    }

    public void afterPropertiesSet() throws Exception {
        ApiStrategyRouter.register(this.appIdSet, this.wandaApiStrategy);
        if (StringUtils.isNotBlank((String)this.authStr)) {
            this.authParams = (Map)JSON.parseObject((String)this.authStr, Map.class);
        }
        DelayNotifyConfig.setDelayLevels(this.appIdSet, this.msgDelayLevel);
    }
}

