/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.remoteimpl.zhiji;

import cn.com.duiba.constant.zhiji.ZhiJiConfig;
import cn.com.duiba.enums.zhiji.ZhiJiCodeEnum;
import cn.com.duiba.enums.zhiji.ZhiJiStatusEnum;
import cn.com.duiba.thirdparty.api.zhiji.RemoteZhiJiService;
import cn.com.duiba.thirdparty.dto.zhiji.ZhiJiUserReceivedAddressDto;
import cn.com.duiba.thirdparty.dto.zhiji.request.ZhiJiBlindBoxRequest;
import cn.com.duiba.thirdparty.dto.zhiji.request.ZhiJiOrderInfoDto;
import cn.com.duiba.thirdparty.dto.zhiji.request.ZhiJiSignProtocolRequest;
import cn.com.duiba.thirdparty.dto.zhiji.response.ZhiJiBlindBoxResponse;
import cn.com.duiba.thirdparty.dto.zhiji.response.ZhiJiOrderResponse;
import cn.com.duiba.thirdparty.dto.zhiji.response.ZhiJiProtocolResponse;
import cn.com.duiba.thirdparty.dto.zhiji.response.ZhiJiResponse;
import cn.com.duiba.tool.zhiji.ZhiJiParamTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteZhiJiServiceImpl
implements RemoteZhiJiService {
    private static final Logger log = LoggerFactory.getLogger(RemoteZhiJiServiceImpl.class);
    @Resource(name="httpClient")
    private CloseableHttpClient httpClient;
    @Autowired
    private ZhiJiConfig zhiJiConfig;
    @Resource(name="stringRedisTemplate")
    private StringRedisTemplate redisTemplate;

    public String saveReceiveAddress(ZhiJiUserReceivedAddressDto dto) {
        HttpPost httpPost = ZhiJiParamTool.createHttpPost(dto, this.zhiJiConfig.getSaveAddressUrl());
        if (httpPost == null) {
            log.warn("\u667a\u5df1-\u65b0\u589e\u6536\u83b7\u5730\u5740\u4fe1\u606f\uff0c\u8bf7\u6c42\u5931\u8d25\uff0cparam:{}", (Object)JSON.toJSONString((Object)dto));
            return ZhiJiStatusEnum.FAIL.getCode();
        }
        httpPost.setHeader("x-transaction-id", System.currentTimeMillis() + ZhiJiParamTool.generateRandom());
        String responseStr = this.zhiJiRequest((HttpUriRequest)httpPost);
        if (StringUtils.isBlank((CharSequence)responseStr)) {
            log.warn("\u667a\u5df1-\u65b0\u589e\u6536\u83b7\u5730\u5740\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
            return ZhiJiStatusEnum.FAIL.getCode();
        }
        ZhiJiResponse respParam = (ZhiJiResponse)JSONObject.parseObject((String)responseStr, ZhiJiResponse.class);
        if (!ZhiJiCodeEnum.SUCCESS_1.getCode().equals(respParam.getCode())) {
            log.warn("\u667a\u5df1-\u65b0\u589e\u6536\u83b7\u5730\u5740\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
            return ZhiJiStatusEnum.FAIL.getCode();
        }
        return respParam.getTransactionId();
    }

    public Boolean removeReceiveAddress(ZhiJiUserReceivedAddressDto dto) {
        HttpPost httpPost = ZhiJiParamTool.createHttpPost(dto, this.zhiJiConfig.getRemoveAddressUrl());
        if (httpPost == null) {
            log.warn("\u667a\u5df1-\u5220\u9664\u6536\u83b7\u5730\u5740\u4fe1\u606f\uff0c\u8bf7\u6c42\u5931\u8d25\uff0cparam:{}", (Object)JSON.toJSONString((Object)dto));
            return false;
        }
        httpPost.setHeader("x-transaction-id", System.currentTimeMillis() + ZhiJiParamTool.generateRandom());
        String responseStr = this.zhiJiRequest((HttpUriRequest)httpPost);
        if (StringUtils.isBlank((CharSequence)responseStr)) {
            log.warn("\u667a\u5df1-\u5220\u9664\u6536\u83b7\u5730\u5740\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
            return false;
        }
        ZhiJiResponse zhiJiResponse = (ZhiJiResponse)JSONObject.parseObject((String)responseStr, ZhiJiResponse.class);
        if (!ZhiJiCodeEnum.SUCCESS_1.getCode().equals(zhiJiResponse.getCode())) {
            log.warn("\u667a\u5df1-\u5220\u9664\u6536\u83b7\u5730\u5740\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
            return false;
        }
        return true;
    }

    public Boolean updateReceiveAddress(ZhiJiUserReceivedAddressDto dto) {
        HttpPost httpPost = ZhiJiParamTool.createHttpPost(dto, this.zhiJiConfig.getUpdateAddressUrl());
        if (httpPost == null) {
            log.warn("\u667a\u5df1-\u7f16\u8f91\u6536\u83b7\u5730\u5740\u4fe1\u606f\uff0c\u8bf7\u6c42\u5931\u8d25\uff0cparam:{}", (Object)JSON.toJSONString((Object)dto));
            return false;
        }
        httpPost.setHeader("x-transaction-id", System.currentTimeMillis() + ZhiJiParamTool.generateRandom());
        String responseStr = this.zhiJiRequest((HttpUriRequest)httpPost);
        if (StringUtils.isBlank((CharSequence)responseStr)) {
            log.warn("\u667a\u5df1-\u7f16\u8f91\u6536\u8d27\u5730\u5740\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
            return false;
        }
        ZhiJiResponse zhiJiResponse = (ZhiJiResponse)JSONObject.parseObject((String)responseStr, ZhiJiResponse.class);
        if (!ZhiJiCodeEnum.SUCCESS_1.getCode().equals(zhiJiResponse.getCode())) {
            log.warn("\u667a\u5df1-\u7f16\u8f91\u6536\u8d27\u5730\u5740\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
            return false;
        }
        return true;
    }

    public List<ZhiJiUserReceivedAddressDto> selectReceiveAddress(String uid) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uid", uid);
        params.put("source", "2");
        HttpGet httpGet = ZhiJiParamTool.createHttpGet(params, this.zhiJiConfig.getSelectUserAddressUrl());
        if (httpGet == null) {
            log.warn("\u667a\u5df1-\u67e5\u8be2\u6536\u83b7\u5730\u5740\u4fe1\u606f\uff0c\u8bf7\u6c42\u5931\u8d25\uff0cparam:{}", (Object)JSON.toJSONString((Object)uid));
            return Collections.emptyList();
        }
        httpGet.setHeader("x-transaction-id", System.currentTimeMillis() + ZhiJiParamTool.generateRandom());
        String responseStr = this.zhiJiRequest((HttpUriRequest)httpGet);
        if (StringUtils.isBlank((CharSequence)responseStr)) {
            log.warn("\u667a\u5df1-\u67e5\u8be2\u6536\u8d27\u5730\u5740\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
            return null;
        }
        ZhiJiResponse zhiJiResponse = (ZhiJiResponse)JSONObject.parseObject((String)responseStr, ZhiJiResponse.class);
        if (!ZhiJiCodeEnum.SUCCESS_1.getCode().equals(zhiJiResponse.getCode())) {
            log.warn("\u667a\u5df1-\u67e5\u8be2\u6536\u8d27\u5730\u5740\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
            return Collections.emptyList();
        }
        JSONObject addressData = JSON.parseObject((String)JSON.toJSONString((Object)zhiJiResponse.getData()));
        List dtoList = JSONObject.parseArray((String)addressData.getString("blocks"), ZhiJiUserReceivedAddressDto.class);
        return dtoList;
    }

    public ZhiJiOrderResponse syncOrderInfo(ZhiJiOrderInfoDto orderInfoDto) {
        HashMap<String, ZhiJiOrderInfoDto> body = new HashMap<String, ZhiJiOrderInfoDto>(1);
        body.put("body", orderInfoDto);
        HttpPost httpPost = ZhiJiParamTool.createHttpPost(body, this.zhiJiConfig.getSyncOrderUrl());
        if (httpPost == null) {
            log.warn("\u667a\u5df1-\u540c\u6b65\u8ba2\u5355\u4fe1\u606f\uff0c\u8bf7\u6c42\u5931\u8d25\uff0cparam:{}", (Object)JSON.toJSONString((Object)orderInfoDto));
            return null;
        }
        String responseStr = this.zhiJiRequest((HttpUriRequest)httpPost);
        if (StringUtils.isBlank((CharSequence)responseStr)) {
            log.warn("\u667a\u5df1-\u540c\u6b65\u8ba2\u5355\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
            return null;
        }
        ZhiJiOrderResponse zhiJiResponse = (ZhiJiOrderResponse)JSONObject.parseObject((String)responseStr, ZhiJiOrderResponse.class);
        if (ZhiJiStatusEnum.FAIL.getCode().equals(zhiJiResponse.getStatus()) || !ZhiJiCodeEnum.SUCCESS.getCode().equals(zhiJiResponse.getCode())) {
            log.warn("\u667a\u5df1-\u540c\u6b65\u8ba2\u5355\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
            return zhiJiResponse;
        }
        return zhiJiResponse;
    }

    public ZhiJiOrderResponse syncOrderStatus(String orderNum, String status) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sourceCode", "DUIBA");
        params.put("traceId", orderNum + RandomUtils.nextInt((int)100000, (int)999999));
        params.put("timestamp", System.currentTimeMillis());
        params.put("orderStatus", status);
        params.put("orderNum", orderNum);
        HashMap<String, HashMap<String, Object>> body = new HashMap<String, HashMap<String, Object>>();
        body.put("body", params);
        HttpPost httpPost = ZhiJiParamTool.createHttpPost(body, this.zhiJiConfig.getSyncOrderStatusUrl());
        if (httpPost == null) {
            log.warn("\u667a\u5df1-\u540c\u6b65\u8ba2\u5355\u72b6\u6001\u4fe1\u606f\uff0c\u8bf7\u6c42\u5931\u8d25\uff0corderNum:{}, status:{}", (Object)orderNum, (Object)status);
            return null;
        }
        String responseStr = this.zhiJiRequest((HttpUriRequest)httpPost);
        if (StringUtils.isBlank((CharSequence)responseStr)) {
            log.warn("\u667a\u5df1-\u540c\u6b65\u8ba2\u5355\u72b6\u6001\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
            return null;
        }
        ZhiJiOrderResponse zhiJiResponse = (ZhiJiOrderResponse)JSONObject.parseObject((String)responseStr, ZhiJiOrderResponse.class);
        if (ZhiJiStatusEnum.FAIL.getCode().equals(zhiJiResponse.getStatus()) || !ZhiJiCodeEnum.SUCCESS.getCode().equals(zhiJiResponse.getCode())) {
            log.warn("\u667a\u5df1-\u540c\u6b65\u8ba2\u5355\u72b6\u6001\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
            return null;
        }
        return zhiJiResponse;
    }

    public JSONObject getUserCredits(String superId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("superId", superId);
        params.put("sourceCode", "DUIBA");
        params.put("traceId", System.currentTimeMillis() + "" + RandomUtils.nextInt((int)100000, (int)999999));
        HashMap<String, HashMap<String, String>> body = new HashMap<String, HashMap<String, String>>();
        body.put("body", params);
        HttpPost httpPost = ZhiJiParamTool.createHttpPost(body, this.zhiJiConfig.getUserCreditsUrl());
        if (httpPost == null) {
            log.warn("\u667a\u5df1-\u67e5\u8be2\u7528\u6237\u79ef\u5206\uff0c\u8bf7\u6c42\u5931\u8d25\uff0cparam:{}", (Object)JSON.toJSONString((Object)superId));
            return null;
        }
        String responseStr = this.zhiJiRequest((HttpUriRequest)httpPost);
        if (StringUtils.isBlank((CharSequence)responseStr)) {
            log.warn("\u667a\u5df1-\u67e5\u8be2\u7528\u6237\u79ef\u5206\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
            return null;
        }
        ZhiJiResponse zhiJiResponse = (ZhiJiResponse)JSONObject.parseObject((String)responseStr, ZhiJiResponse.class);
        if (!ZhiJiCodeEnum.SUCCESS_2.getCode().equals(zhiJiResponse.getCode())) {
            log.warn("\u667a\u5df1-\u67e5\u8be2\u7528\u6237\u79ef\u5206\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
            return null;
        }
        return JSON.parseObject((String)JSON.toJSONString((Object)zhiJiResponse));
    }

    public JSONObject queryUserInfo(String token) {
        HashMap<String, String> params = new HashMap<String, String>();
        HttpGet httpGet = ZhiJiParamTool.createHttpGet(params, this.zhiJiConfig.getQueryUserInfoUrl());
        if (httpGet == null) {
            log.warn("\u667a\u5df1-\u67e5\u8be2\u7528\u6237id\u4fe1\u606f\uff0c\u8bf7\u6c42\u5931\u8d25\uff0cparam:{}", (Object)JSON.toJSONString((Object)token));
            return null;
        }
        httpGet.setHeader("Authorization", "Bearer " + token);
        httpGet.setHeader("x-transaction-id", System.currentTimeMillis() + "@" + ZhiJiParamTool.generateRandom() + "_duiba");
        log.info("\u667a\u5df1-\u67e5\u8be2\u7528\u6237\u8bf7\u6c42\u53c2\u6570\uff0cheader:{}", (Object)JSON.toJSONString((Object)httpGet.getAllHeaders()));
        String responseStr = this.zhiJiRequest((HttpUriRequest)httpGet);
        if (StringUtils.isBlank((CharSequence)responseStr)) {
            log.warn("\u667a\u5df1-\u67e5\u8be2\u7528\u6237id\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
            return null;
        }
        ZhiJiResponse zhiJiResponse = (ZhiJiResponse)JSONObject.parseObject((String)responseStr, ZhiJiResponse.class);
        if (!ZhiJiCodeEnum.SUCCESS_2.getCode().equals(zhiJiResponse.getResultCode())) {
            log.warn("\u667a\u5df1-\u67e5\u8be2\u7528\u6237id\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
            return null;
        }
        return JSONObject.parseObject((String)zhiJiResponse.getData().toString());
    }

    public boolean syncGoods(Map<String, Object> params) {
        HashMap<String, Map<String, Object>> body = new HashMap<String, Map<String, Object>>();
        body.put("body", params);
        HttpPost httpPost = ZhiJiParamTool.createHttpPost(body, this.zhiJiConfig.getSyncGoodsUrl());
        if (httpPost == null) {
            log.warn("\u667a\u5df1-\u65b0\u589e\u6536\u83b7\u5730\u5740\u4fe1\u606f\uff0c\u8bf7\u6c42\u5931\u8d25\uff0cparam:{}", (Object)JSON.toJSONString(params));
            return false;
        }
        String responseStr = this.zhiJiRequest((HttpUriRequest)httpPost);
        if (StringUtils.isBlank((CharSequence)responseStr)) {
            log.warn("\u667a\u5df1-\u540c\u6b65\u5546\u54c1\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
            return false;
        }
        ZhiJiResponse zhiJiResponse = (ZhiJiResponse)JSONObject.parseObject((String)responseStr, ZhiJiResponse.class);
        if (ZhiJiStatusEnum.FAIL.getCode().equals(zhiJiResponse.getStatus()) || !ZhiJiCodeEnum.SUCCESS.getCode().equals(zhiJiResponse.getCode())) {
            log.warn("\u667a\u5df1-\u540c\u6b65\u5546\u54c1\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
            return false;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)zhiJiResponse.getData().toString());
        return Objects.equals(jsonObject.getString("code"), "0");
    }

    public JSONArray queryDistrictList(String keywords, Integer subDistrict) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("keywords", keywords);
        params.put("subDistrict", String.valueOf(subDistrict));
        HttpGet httpGet = ZhiJiParamTool.createHttpGet(params, this.zhiJiConfig.getSelectDistrictUrl());
        if (httpGet == null) {
            log.warn("\u667a\u5df1-\u7701\u5e02\u533a\uff0c\u8bf7\u6c42\u5931\u8d25\uff0ckeywords:{},subDistrict:{}", (Object)keywords, (Object)subDistrict);
            return null;
        }
        String responseStr = this.zhiJiRequest((HttpUriRequest)httpGet);
        if (StringUtils.isBlank((CharSequence)responseStr)) {
            log.warn("\u667a\u5df1-\u7701\u5e02\u533a\u67e5\u8be2\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
            return null;
        }
        ZhiJiResponse zhiJiResponse = (ZhiJiResponse)JSONObject.parseObject((String)responseStr, ZhiJiResponse.class);
        if (!ZhiJiCodeEnum.SUCCESS_1.getCode().equals(zhiJiResponse.getCode())) {
            log.warn("\u667a\u5df1-\u7701\u5e02\u533a\u67e5\u8be2\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
            return null;
        }
        JSONObject address = JSON.parseObject((String)JSON.toJSONString((Object)zhiJiResponse.getData()));
        return address.getJSONArray("blocks");
    }

    public Boolean blindBoxVerify(String uid, String blindBoxId, String goodsId) {
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("userId", uid);
        params.put("blindBoxId", blindBoxId);
        params.put("goodsId", goodsId);
        HttpPost httpPost = ZhiJiParamTool.createHttpPost(params, this.zhiJiConfig.getBlindBoxVerifyUrl());
        if (httpPost == null) {
            log.warn("\u667a\u5df1-\u76f2\u76d2\u9a8c\u8bc1\uff0c\u8bf7\u6c42\u5931\u8d25\uff0cuid:{},blindBoxId:{},goodsId:{}", new Object[]{uid, blindBoxId, goodsId});
            return false;
        }
        String responseStr = this.zhiJiRequest((HttpUriRequest)httpPost);
        if (StringUtils.isBlank((CharSequence)responseStr)) {
            log.warn("\u667a\u5df1-\u76f2\u76d2\u9a8c\u8bc1\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
            return false;
        }
        ZhiJiBlindBoxResponse zhiJiResponse = (ZhiJiBlindBoxResponse)JSONObject.parseObject((String)responseStr, ZhiJiBlindBoxResponse.class);
        return zhiJiResponse != null && zhiJiResponse.getData() != null && Objects.equals(1, zhiJiResponse.getData().getCheckStatus());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String zhiJiRequest(HttpUriRequest httpRequest) {
        try (CloseableHttpResponse response = this.httpClient.execute(httpRequest);){
            String responseStr = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("\u667a\u5df1\uff0c\u667a\u5df1\u54cd\u5e94\u53c2\u6570\uff0cparam:{}", (Object)responseStr);
            String string = responseStr;
            return string;
        }
        catch (Exception e) {
            log.warn("\u667a\u5df1\uff0c\u667a\u5df1\u54cd\u5e94\u5f02\u5e38\uff0curl:{},param:{}", new Object[]{httpRequest.getURI().getPath(), JSON.toJSONString((Object)httpRequest), e});
            return null;
        }
    }

    public void notifyBlindBoxWriteOff(ZhiJiBlindBoxRequest request) {
        HttpPost httpPost = ZhiJiParamTool.createHttpPost(request, this.zhiJiConfig.getNotifyBlindBoxUrl());
        if (httpPost == null) {
            log.warn("\u667a\u5df1-\u76f2\u76d2\u6838\u9500\u901a\u77e5\uff0c\u8bf7\u6c42\u5931\u8d25\uff0cparam:{}", (Object)JSON.toJSONString((Object)request));
            return;
        }
        this.zhiJiRequest((HttpUriRequest)httpPost);
    }

    public JSONObject queryOrderAddress(List<String> orderIds) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("timestamp", System.currentTimeMillis());
        params.put("orderNumList", Joiner.on((String)",").join(orderIds));
        params.put("sourceCode", "DUIBA");
        params.put("traceId", System.currentTimeMillis() + "" + RandomUtils.nextInt((int)100000, (int)999999));
        HashMap<String, HashMap<String, Object>> body = new HashMap<String, HashMap<String, Object>>();
        body.put("body", params);
        HttpPost httpPost = ZhiJiParamTool.createHttpPost(body, this.zhiJiConfig.getQueryOrderAddressListUrl());
        if (httpPost == null) {
            log.warn("\u667a\u5df1-\u6279\u91cf\u67e5\u8be2\u6536\u8d27\u5730\u5740\uff0c\u8bf7\u6c42\u5931\u8d25\uff0cparam:{}", (Object)JSON.toJSONString(orderIds));
            return null;
        }
        String responseStr = this.zhiJiRequest((HttpUriRequest)httpPost);
        if (StringUtils.isBlank((CharSequence)responseStr)) {
            log.warn("\u667a\u5df1-\u6279\u91cf\u67e5\u8be2\u6536\u8d27\u5730\u5740\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
            return null;
        }
        ZhiJiResponse zhiJiResponse = (ZhiJiResponse)JSONObject.parseObject((String)responseStr, ZhiJiResponse.class);
        if (ZhiJiStatusEnum.FAIL.getCode().equals(zhiJiResponse.getStatus()) || !ZhiJiCodeEnum.SUCCESS.getCode().equals(zhiJiResponse.getCode())) {
            log.warn("\u667a\u5df1-\u6279\u91cf\u67e5\u8be2\u6536\u8d27\u5730\u5740\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
            return null;
        }
        return JSONObject.parseObject((String)zhiJiResponse.getData().toString());
    }

    public void pushMsg(String nickname, String itemName, String uid) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("receiverId", uid);
        JSONObject parameters = new JSONObject();
        parameters.put("nickname", (Object)nickname);
        parameters.put("itemName", (Object)itemName);
        params.put("parameters", (String)parameters);
        params.put("callOrigin", "DUIBA");
        params.put("templateId", "");
        HttpPost httpPost = ZhiJiParamTool.createHttpPost(params, this.zhiJiConfig.getPushMessageUrl());
        if (httpPost == null) {
            log.warn("\u667a\u5df1-\u6d88\u606f\u63a8\u9001\uff0c\u8bf7\u6c42\u5931\u8d25\uff0cnickName:{},itemName:{},uid:{}", new Object[]{nickname, itemName, uid});
            return;
        }
        this.zhiJiRequest((HttpUriRequest)httpPost);
    }

    public ZhiJiProtocolResponse getProtocolById(String protocolId) {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("protocolId", protocolId);
        HttpPost httpPost = ZhiJiParamTool.createHttpPost(params, this.zhiJiConfig.queryProtocolUrl);
        httpPost.setHeader("x-transaction-id", System.currentTimeMillis() + ZhiJiParamTool.generateRandom());
        String responseStr = this.zhiJiRequest((HttpUriRequest)httpPost);
        if (StringUtils.isBlank((CharSequence)responseStr)) {
            log.warn("\u667a\u5df1-\u67e5\u8be2\u9690\u79c1\u534f\u8bae\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
            return null;
        }
        ZhiJiResponse zhiJiResponse = (ZhiJiResponse)JSONObject.parseObject((String)responseStr, ZhiJiResponse.class);
        if (!ZhiJiCodeEnum.SUCCESS_1.getCode().equals(zhiJiResponse.getCode())) {
            log.warn("\u667a\u5df1-\u67e5\u8be2\u9690\u79c1\u534f\u8bae\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
            return null;
        }
        return (ZhiJiProtocolResponse)JSON.parseObject((String)JSON.toJSONString((Object)zhiJiResponse.getData()), ZhiJiProtocolResponse.class);
    }

    public Double getProtocolVersion(String accessToken) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("accessToken", accessToken);
        params.put("protocolId", "YS00001");
        HttpPost httpPost = ZhiJiParamTool.createHttpPost(params, this.zhiJiConfig.getProtocolVersionUrl);
        httpPost.setHeader("x-transaction-id", System.currentTimeMillis() + ZhiJiParamTool.generateRandom());
        String responseStr = this.zhiJiRequest((HttpUriRequest)httpPost);
        if (StringUtils.isBlank((CharSequence)responseStr)) {
            log.warn("\u667a\u5df1-\u67e5\u8be2\u9690\u79c1\u534f\u8bae\u7248\u672c\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
            return null;
        }
        ZhiJiResponse zhiJiResponse = (ZhiJiResponse)JSONObject.parseObject((String)responseStr, ZhiJiResponse.class);
        if (!ZhiJiCodeEnum.SUCCESS_1.getCode().equals(zhiJiResponse.getCode())) {
            log.warn("\u667a\u5df1-\u67e5\u8be2\u9690\u79c1\u534f\u8bae\u7248\u672c\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
            return null;
        }
        return JSON.parseObject((String)JSON.toJSONString((Object)zhiJiResponse.getData())).getDouble("version");
    }

    public Boolean signProtocol(ZhiJiSignProtocolRequest request) {
        HttpPost httpPost = ZhiJiParamTool.createHttpPost(request, this.zhiJiConfig.signProtocolUrl);
        httpPost.setHeader("x-transaction-id", System.currentTimeMillis() + ZhiJiParamTool.generateRandom());
        String responseStr = this.zhiJiRequest((HttpUriRequest)httpPost);
        if (StringUtils.isBlank((CharSequence)responseStr)) {
            log.warn("\u667a\u5df1-\u7b7e\u7f72\u9690\u79c1\u534f\u8bae\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
            return false;
        }
        ZhiJiResponse zhiJiResponse = (ZhiJiResponse)JSONObject.parseObject((String)responseStr, ZhiJiResponse.class);
        if (!ZhiJiCodeEnum.SUCCESS_1.getCode().equals(zhiJiResponse.getCode())) {
            log.warn("\u667a\u5df1-\u7b7e\u7f72\u9690\u79c1\u534f\u8bae\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
            return false;
        }
        return true;
    }
}

