/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.impl;

import cn.com.duiba.api.bo.credits.CreditsRequest;
import cn.com.duiba.api.bo.credits.CreditsResponse;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.service.impl.CreditsLogExtractor;
import cn.com.duiba.thirdparty.dto.ConsumerCreditsLogSaveDto;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractCreditsLogExtractor
implements CreditsLogExtractor {
    private static final Logger log = LoggerFactory.getLogger(AbstractCreditsLogExtractor.class);

    AbstractCreditsLogExtractor() {
    }

    @Override
    public boolean supports(CreditsRequest request, CreditsResponse response) {
        return this.supportsInternal(request, response);
    }

    @Override
    public ConsumerCreditsLogSaveDto extract(CreditsRequest request, CreditsResponse response) {
        ConsumerCreditsLogSaveDto creditsLog = this.extractInternal(request, response);
        if (creditsLog == null) {
            return null;
        }
        Map<String, String> params = this.extractRequestParams(request);
        if (MapUtils.isEmpty(params)) {
            return null;
        }
        creditsLog.setOrderNum(params.get("orderNum"));
        creditsLog.setBizType(params.get("type"));
        if (params.get("credits") == null) {
            this.removeAppSecret(request);
            return null;
        }
        creditsLog.setCredits(Long.valueOf(Long.parseLong(params.get("credits"))));
        creditsLog.setDescription(params.get("description"));
        return creditsLog;
    }

    private void removeAppSecret(CreditsRequest request) {
        SubCreditsMsgWrapper subCreditsMsgWrapper;
        if (request != null && request instanceof SubCreditsMsgWrapper && (subCreditsMsgWrapper = (SubCreditsMsgWrapper)request).getSubCreditsMsg() != null) {
            subCreditsMsgWrapper.getSubCreditsMsg().setAppSecret(null);
        }
    }

    protected abstract boolean supportsInternal(CreditsRequest var1, CreditsResponse var2);

    protected abstract Map<String, String> extractRequestParams(CreditsRequest var1);

    protected abstract ConsumerCreditsLogSaveDto extractInternal(CreditsRequest var1, CreditsResponse var2);
}

