/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.impl;

import cn.com.duiba.service.DuibaVirtualManager;
import cn.com.duiba.service.DuibaVirtualSupplier;
import cn.com.duiba.thirdparty.dto.SupplierRequestDto;
import cn.com.duiba.thirdparty.enums.virtual.VirtualItemChannelEnum;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DuibaVirtualConsumeManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DuibaVirtualConsumeManager.class);
    @Autowired
    private DuibaVirtualManager duibaVirtualManager;

    public void handleMqMessage(String body) {
        if (StringUtils.isBlank((CharSequence)body)) {
            LOGGER.info("DuibaVirtualConsumeManager.body is null");
            return;
        }
        SupplierRequestDto request = (SupplierRequestDto)JSONObject.parseObject((String)body, SupplierRequestDto.class);
        VirtualItemChannelEnum virtualItemChannelEnum = VirtualItemChannelEnum.getByCode((String)request.getVirtualTypeCode());
        if (virtualItemChannelEnum == null) {
            LOGGER.info("DuibaVirtualConsumeManager.VirtualItemChannelEnum is null,body:{}", (Object)body);
            return;
        }
        DuibaVirtualSupplier duibaVirtualSupplier = this.duibaVirtualManager.getSupplier(virtualItemChannelEnum.getCode());
        if (duibaVirtualSupplier == null) {
            LOGGER.info("DuibaVirtualConsumeManager.duibaVirtualSupplier is null,body:{}", (Object)body);
            return;
        }
        LOGGER.info("\u5f00\u59cb\u5904\u7406\u5151\u5427\u865a\u62df\u5546\u54c1\u8bf7\u6c42,request:{}", (Object)JSON.toJSONString((Object)request));
        duibaVirtualSupplier.submit(request);
    }
}

