/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.impl;

import cn.com.duiba.service.KeyProvider;
import java.io.BufferedInputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;

public class KeyProviderImpl
implements KeyProvider {
    private static final Map<String, String> SUPPORTED_KEY_TYPE = new HashMap<String, String>();
    private String file;
    private String password;
    private KeyStore keystore;
    private boolean initialized = false;

    public KeyProviderImpl(String file, String password) {
        Assert.notNull((Object)file, (String)"file is required; it must not be null");
        this.init(file, password);
    }

    private String resolveType(String file) {
        Assert.notNull((Object)file, (String)"file is required; it must not be null");
        String suffix = file.substring(file.lastIndexOf(".") + 1);
        Assert.notNull((Object)suffix, (String)"suffix could not be resolved");
        String supportedType = SUPPORTED_KEY_TYPE.get(suffix.toLowerCase());
        Assert.notNull((Object)supportedType, (String)"unsupported key type");
        return supportedType;
    }

    private void init(String file, String password) {
        try (BufferedInputStream is = new BufferedInputStream(KeyProviderImpl.class.getResourceAsStream(file));){
            this.keystore = KeyStore.getInstance(this.resolveType(file));
            char[] pwd = password == null ? null : password.toCharArray();
            this.keystore.load(is, pwd);
            this.initialized = true;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Key getKey(String id, String password) {
        Assert.isTrue((boolean)this.initialized, (String)"keyProvider not been initialized");
        try {
            if (id == null) {
                Enumeration<String> aliases = this.keystore.aliases();
                int count = 0;
                while (aliases.hasMoreElements()) {
                    if (count > 1) {
                        throw new IllegalArgumentException("key id not specified");
                    }
                    String alias = aliases.nextElement();
                    if (this.keystore.isKeyEntry(alias)) {
                        id = alias;
                    }
                    ++count;
                }
            }
            char[] pwd = password == null ? null : password.toCharArray();
            return this.keystore.getKey(id, pwd);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Certificate getCertificate(String id) {
        Assert.isTrue((boolean)this.initialized, (String)"keyProvider not been initialized");
        try {
            return this.keystore.getCertificate(id);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Certificate[] getCertificateChain(String id) {
        Assert.isTrue((boolean)this.initialized, (String)"keyProvider not been initialized");
        try {
            return this.keystore.getCertificateChain(id);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    static {
        SUPPORTED_KEY_TYPE.put("ks", "jks");
        SUPPORTED_KEY_TYPE.put("jks", "jks");
        SUPPORTED_KEY_TYPE.put("pfx", "pkcs12");
        SUPPORTED_KEY_TYPE.put("p12", "pkcs12");
    }
}

