/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tool;

import com.google.common.collect.Lists;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunHeadlinesSignTool {
    private static final Logger LOGGER = LoggerFactory.getLogger(FunHeadlinesSignTool.class);
    private static final String HEXADECIMAL_ZERO_PADDING_FORMAT = "%02x";
    private static final String SIGNATURE_ARITHMETIC = "MD5";
    private static final String SIGN_PARAM = "sign";
    private static final String APP_KEY = "app_key";

    public static String sign(Map<String, String> paramMap, String appKey) {
        paramMap.remove(SIGN_PARAM);
        paramMap.put(APP_KEY, appKey);
        ArrayList keys = Lists.newArrayList();
        keys.addAll(paramMap.keySet());
        keys.sort((l, r) -> {
            int i = l.compareTo((String)r);
            if (i > 0) {
                return 1;
            }
            return -1;
        });
        String hashed = "";
        String r2 = keys.stream().map(i -> i + (String)paramMap.get(i)).collect(Collectors.joining());
        try {
            hashed = FunHeadlinesSignTool.getMD5(r2);
        }
        catch (Exception e) {
            LOGGER.error("[FunHeadlinesSignTool-sign]\u8da3\u5934\u6761-\u7b7e\u540d\u9519\u8bef\uff1a", (Throwable)e);
        }
        paramMap.remove(APP_KEY);
        return hashed;
    }

    public static boolean checkSign(Map<String, String> paramMap, String appKey) throws Exception {
        String originSign = paramMap.get(SIGN_PARAM);
        if (StringUtils.isBlank((String)originSign)) {
            throw new Exception("\u7b7e\u540d\u9519\u8bef");
        }
        String sign = FunHeadlinesSignTool.sign(paramMap, appKey);
        if (!originSign.equals(sign)) {
            throw new Exception("\u7b7e\u540d\u9519\u8bef");
        }
        return true;
    }

    private static String getMD5(String need2Encode) throws NoSuchAlgorithmException {
        byte[] buf = need2Encode.getBytes();
        MessageDigest md5 = MessageDigest.getInstance(SIGNATURE_ARITHMETIC);
        md5.update(buf);
        byte[] tmp = md5.digest();
        StringBuilder sb = new StringBuilder();
        for (byte b : tmp) {
            sb.append(String.format(HEXADECIMAL_ZERO_PADDING_FORMAT, b & 0xFF));
        }
        return sb.toString();
    }
}

