/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tool.sn;

import cn.com.duiba.dto.sn.SnbRequestParam;
import cn.com.duiba.service.KeyMetadata;
import cn.com.duiba.tool.sn.InitData;
import cn.com.duiba.tool.sn.SignatureVerifier;
import cn.com.duiba.tool.sn.SnbUtil;

public class SnbSignUtil {
    public static String ENV = "";
    public static SignatureVerifier VERIFIER = new SignatureVerifier();
    public static KeyMetadata keyMetadata;

    public static void initApi(String appCode, String channelId) {
        SnbRequestParam.setAppCode(appCode);
        SnbRequestParam.setChannelId(channelId);
        SnbUtil.loadSnbPublicKey();
    }

    public static void setEnv(InitData.ENV env) {
        switch (env) {
            case sit: {
                ENV = "sit";
                break;
            }
            case uat: {
                ENV = "uat";
                break;
            }
            case prd: {
                ENV = "";
                break;
            }
        }
    }

    public static String getSnbPublicKeyPath() {
        String snbPublicKeyPath = "/bankKey/SnbPublicKey" + ENV + ".cer";
        return snbPublicKeyPath;
    }

    public static void setKeyMetadata(String keyStorePwd, String keyPwd, String merPrivatePath) {
        if (merPrivatePath == null) {
            merPrivatePath = InitData.MerPriKeyPath;
        }
        if (!merPrivatePath.endsWith("/")) {
            merPrivatePath = merPrivatePath + "/";
        }
        merPrivatePath = merPrivatePath + "MerPriKey" + ENV + ".pfx";
        keyMetadata = new KeyMetadata("1", merPrivatePath, keyStorePwd, null, keyPwd);
    }
}

