/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tool.zhiji;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZhiJiParamTool {
    private static final Logger log = LoggerFactory.getLogger(ZhiJiParamTool.class);
    private static final String MAC_NAME = "HmacSHA256";
    private static final String ENCODING = "UTF-8";
    private static final String TEST_ENCRYPT_KEY = "myi6MBoU8PSIXnrkC6nogKKd1yM9x1Q8";
    private static final String PROD_ENCRYPT_KEY = "dF0Watf8GszMNpsJ4jC3YG4JBxK9A7Qu";
    private static final RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(10000).setConnectionRequestTimeout(500).build();
    private static final int FIVE_SECONDS = 5000;
    private static final int TEN_SECONDS = 10000;

    public static HttpPost createHttpPost(Object dto, String url) {
        if (dto == null || StringUtils.isBlank((String)url)) {
            return null;
        }
        log.info("\u667a\u5df1-post\u8bf7\u6c42\u53c2\u6570\uff0curl:{}, params:{}", (Object)url, (Object)JSON.toJSONString((Object)dto));
        HttpPost httpPost = new HttpPost(url);
        byte[] bytes = ZhiJiParamTool.hmacEncrypt(JSON.toJSONString((Object)dto));
        if (bytes == null) {
            log.warn("\u667a\u5df1-\u53d1\u9001\u8bf7\u6c42\uff0c\u53c2\u6570\u52a0\u5bc6\u5931\u8d25\uff0curl:{}, param:{}", (Object)url, (Object)JSON.toJSONString((Object)dto));
            return null;
        }
        String signature = Hex.encodeHexString((byte[])bytes);
        httpPost.setHeader("signature", signature);
        httpPost.setHeader("Content-Type", "application/json;charset=utf-8");
        try {
            httpPost.setEntity((HttpEntity)new StringEntity(JSON.toJSONString((Object)dto)));
        }
        catch (UnsupportedEncodingException e) {
            log.warn("\u667a\u5df1-\u53d1\u9001\u8bf7\u6c42\uff0cpost\u53c2\u6570\uff0curl:{}, param:{}", (Object)url, (Object)JSON.toJSONString((Object)dto));
            return null;
        }
        httpPost.setConfig(requestConfig);
        log.info("\u667a\u5df1-post\u8bf7\u6c42\u53c2\u6570\uff0cparams:{},signature:{},header:{}", new Object[]{JSON.toJSONString((Object)dto), signature, JSON.toJSONString((Object)httpPost.getAllHeaders())});
        return httpPost;
    }

    public static HttpGet createHttpGet(Map<String, String> params, String url) {
        if (params == null || StringUtils.isBlank((String)url)) {
            return null;
        }
        log.info("\u667a\u5df1-get\u8bf7\u6c42\u53c2\u6570\uff0curl:{}, params:{}", (Object)url, (Object)JSON.toJSONString(params));
        byte[] bytes = ZhiJiParamTool.hmacEncrypt(JSON.toJSONString(params));
        if (bytes == null) {
            log.warn("\u667a\u5df1-\u53d1\u9001\u8bf7\u6c42\uff0c\u53c2\u6570\u52a0\u5bc6\u5931\u8d25\uff0curl:{}, param:{}", (Object)url, (Object)JSON.toJSONString(params));
            return null;
        }
        StringBuilder param = new StringBuilder(url).append("?");
        ArrayList paramList = new ArrayList();
        params.entrySet().forEach(entry -> paramList.add((String)entry.getKey() + "=" + (String)entry.getValue()));
        param.append(StringUtils.join(paramList, (String)"&"));
        HttpGet httpGet = new HttpGet(param.toString());
        String signature = Hex.encodeHexString((byte[])bytes);
        httpGet.setHeader("signature", signature);
        httpGet.setHeader("Content-Type", "application/json;charset=utf-8");
        log.info("\u667a\u5df1-get\u8bf7\u6c42\u53c2\u6570\uff0curl:{},signature:{},header:{}", new Object[]{param.toString(), signature, JSON.toJSONString((Object)httpGet.getAllHeaders())});
        httpGet.setConfig(requestConfig);
        return httpGet;
    }

    public static Map<String, String> dtoConvertParams(Object obj) throws IllegalAccessException {
        Field[] fields;
        if (obj == null) {
            return null;
        }
        HashMap params = Maps.newHashMap();
        Class<?> clazz = obj.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            field.setAccessible(true);
            if (field.get(obj) == null) continue;
            params.put(field.getName(), String.valueOf(field.get(obj)));
        }
        return params;
    }

    public static byte[] hmacEncrypt(String encryptText) {
        String encryptKey = TEST_ENCRYPT_KEY;
        if (SpringEnvironmentUtils.isProdEnv() || SpringEnvironmentUtils.isPreEnv()) {
            encryptKey = PROD_ENCRYPT_KEY;
        }
        try {
            byte[] data = encryptKey.getBytes(ENCODING);
            SecretKeySpec secretKey = new SecretKeySpec(data, MAC_NAME);
            Mac mac = Mac.getInstance(MAC_NAME);
            mac.init(secretKey);
            byte[] text = encryptText.getBytes(ENCODING);
            return mac.doFinal(text);
        }
        catch (Exception e) {
            log.error("\u667a\u5df1-hmac\u52a0\u5bc6\u5931\u8d25\uff0cencryptText\uff1a{}", (Object)encryptText, (Object)e);
            return null;
        }
    }

    public static String generateRandom() {
        return String.valueOf(RandomUtils.nextInt((int)100000, (int)999999));
    }
}

