package cn.com.duiba.biz.credits;

import cn.com.duiba.constant.IcbcElifeConfig;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.icbc.RSAUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * 工行卡中心定制  欢趣豆
 * @author pengkai
 * @date 2019/11/18
 */
@Service
public class IcbcElifeApi {

    private Logger logger = LoggerFactory.getLogger(IcbcElifeApi.class);

    /** 请求参数json 定义*/
//    private static final String TRADE_ID = "tradeId";
//    private static final String USER_ID = "userId";
//    private static final String SCORE = "score";
//    private static final String ACT_NAME = "actName";
//
//    private static final String APP_KEY = "app_key";
//    private static final String DATA = "data";
//    private static final String SIGN = "sign";
//    private static final String ACCESS_TOKEN= "access_token";
//    private static final String FORMAT= "format";
//    private static final String NAME= "name";
//    private static final String VERSION= "version";
//    private static final String TIME_STAMP= "timestamp";
//
//    /** 获取传参 定义*/
//    private static final String DESC = "description";
//    private static final String ORDER_NUM = "orderNum";
//    private static final String UID = "uid";
//    private static final String CREDITS = "credits";
//
//
//    /** 返回结果 定义*/
//    private static final String TRADE_TYPE = "tradeType";
//    private static final String STATUS = "status";
//    private static final String HANDLER = "HandlerManner";
//
//    /** 请求类型 */
//    private static final String ADD_SCORE= "score.add";
//    private static final String SUB_SCORE= "score.deduct";
//    private static final String CHECK_SCORE= "score.check";

    @Autowired
    private IcbcElifeConfig icbcElifeConfig;
//    @Resource(name = "httpClient")
//    private CloseableHttpClient httpClient;
//    @Autowired
//    private IcbcElifeRollbackCreditLogDAO icbcElifeRollbackCreditLogDAO;
//    @Resource(name = "httpCallbackExecutorService")
//    private ExecutorService httpCallbackExecutorService;
//    @Autowired
//    private AppDAO appDAO;

//    /**
//     * 组装扣积分对象  remote形式发起的扣积分请求
//     * @param request
//     * @return
//     */
//    public CreditsMessage getSubCreditsMessage(CreditsMessage request) {
//        try {
//            String url = request.getHttpUrl();
//            String host = url.substring(0, url.indexOf('?'));
//            String params = url.substring(url.indexOf('?') + 1);
//            // 1.将请求URL的参数转换为MAP
//            Map<String, String> paramMap = AssembleTool.getUrlParams(params);
//
//            request.setHttpType(CreditsMessage.HTTP_POST);
//            request.setHttpUrl(host);
//            Map<String, String> authParams = buildAuthParams(paramMap,SUB_SCORE,"");
//            request.setAuthParams(authParams);
//            return request;
//        } catch (Exception e) {
//            logger.info("getSubCreditsMessage call CreditsMessage error , CreditsMessage = {}", JSONObject.toJSONString(request), e);
//            return request;
//        }
//    }



//    /**
//     * 组装扣积分对象  mq形式发起的扣积分请求
//     * @param subCreditsMsgWrapper
//     * @return
//     */
//    public SubCreditsMsgWrapper getSubCreditsMessage(SubCreditsMsgWrapper subCreditsMsgWrapper) {
//        try {
//            SubCreditsMsgDto subCreditsMsgDto = subCreditsMsgWrapper.getSubCreditsMsg();
//            String url = subCreditsMsgWrapper.getHttpUrl();
//            String host = url.substring(0, url.indexOf('?'));
//            String urlParams = url.substring(url.indexOf('?') + 1, url.length());
//            // 1.将请求URL的参数转换为MAP
//            Map<String, String> crediMap = AssembleTool.getUrlParams(urlParams);
//
//            subCreditsMsgDto.setHttpType(SubCreditsMsgDto.HTTP_POST);
//            subCreditsMsgWrapper.setHttpUrl(host);
////            subCreditsMsgWrapper.setHttpUrl("http://29.100.152.66:8980/js/openapi");
//            Map<String, String> authParams = buildAuthParams(crediMap, SUB_SCORE,
//                    subCreditsMsgWrapper.getSubCreditsMsg().getCreditConsumeParams().getItemCode());
//
//            subCreditsMsgWrapper.getSubCreditsMsg().setAuthParams(authParams);
//            return subCreditsMsgWrapper;
//        } catch (Exception e) {
//            logger.info("getSubCreditsMessage call getSubCreditsMessage error , subCreditsMsgWrapper = {}", JSONObject.toJSONString(subCreditsMsgWrapper), e);
//            return subCreditsMsgWrapper;
//        }
//    }

//    /**
//     * 组装加积分对象 正常加积分
//     * @param request
//     * @return
//     */
//    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request) throws BizException {
//        try {
//            request.setHttpType(CreditsMessageDto.HTTP_POST);
//            String url = request.getHttpUrl();
//            String host = url.indexOf('?') == -1 ? url : url.substring(0, url.indexOf('?'));
//            request.setHttpUrl(host);
//            Map<String, String> authParams = buildAuthParams(request.getAuthParams(),ADD_SCORE,"");
//            request.setAuthParams(authParams);
//            return request;
//        } catch (Exception ex) {
//            logger.info("getAddCreditsMessage call getSubCreditsMessage error , request = {}", JSONObject.toJSONString(request), ex);
//            throw new BizException("工行卡加积分流程中断");
//        }
//    }

//    public String parseCreditsRsp(String body) {
//        JSONObject jsonBody;
//        try {
//            jsonBody = JSON.parseObject(body);
//        } catch (Exception e) {
//            logger.error("JSON.parseObject:", e);
//            return body;
//        }
//        JSONObject json = JsonTool.getAllJson(jsonBody);
//        Map<String, String> duibaDoc = new HashMap<>();
//        String status = json.getString("code");
//        if ("0".equals(status)) {
//            duibaDoc.put("status", "ok");
//            duibaDoc.put("credits", String.valueOf(json.getLongValue("score")));
//        } else {
//            duibaDoc.put("errorCode",status);
//            duibaDoc.put("status", "fail");
//            duibaDoc.put("errorMessage", json.getString("msg"));
//        }
//        return JsonTool.objectToJson(duibaDoc);
//    }

//    /**
//     *
//     * @param originAuthParams
//     * @param type 添加积分还是扣减积分
//     * @return
//     * @throws UnsupportedEncodingException
//     */
//    private Map<String, String> buildAuthParams(Map<String, String> originAuthParams,String type,String itemCode) throws UnsupportedEncodingException {
////        logger.info("icbc e life AuthParams :{} type = {}  itemCode = {} ",JSONObject.toJSONString(originAuthParams), type, itemCode);
//        Map<String, String> authParams = Maps.newHashMap();
//
//        Map<String, String> dataParam = Maps.newHashMap();
//        //业务订单号
//        dataParam.put(TRADE_ID,originAuthParams.get(ORDER_NUM));
//        //用户ID
//        dataParam.put(USER_ID,originAuthParams.get(UID));
//        //积分
//        dataParam.put(SCORE,originAuthParams.get(CREDITS));
//        //活动名称  三个来源 -> 1 transfer  2 兑换：商品编码  3 description
//        String actCode = "";
//        String transfer = originAuthParams.get("transfer");
//        if(StringUtils.isNotBlank(transfer)){
//            String[] transArr = transfer.split("=");
//            if(transArr.length == 2){
//                actCode = transArr[1];
//            }else {
//                transfer = URLDecoder.decode(transfer, "UTF-8" );
//                String[] transArrDecode = transfer.split("=");
//                if(transArrDecode.length == 2){
//                    actCode = transArrDecode[1];
//                }
//            }
//        }
//
//        if(StringUtils.isNotBlank(itemCode)){
//            actCode = itemCode;
//        }
//
//        IcbcElifeActNameEnum code = IcbcElifeActNameEnum.getByName(originAuthParams.get(DESC));
//        if(null != code ){
//            actCode = code.getCode();
//        }
//        dataParam.put(ACT_NAME,actCode);
//        authParams.put(APP_KEY,icbcElifeConfig.getAppKey());
//        authParams.put(ACCESS_TOKEN,"");
//        authParams.put(FORMAT,"json");
//        authParams.put(NAME,type);
//        authParams.put(VERSION,"1.0");
//
//        authParams.put(TIME_STAMP, DateUtils.getSecondStr(new Date()));
//        authParams.put(DATA,URLEncoder.encode(JSON.toJSONString(dataParam),"UTF-8"));
//        authParams.put(SIGN, IcbcSignTool.createSign(authParams,icbcElifeConfig.getAppSecret()));
//        return authParams;
//    }


    //////////////////////////////////////////////回滚积分//////////////////////////////////////////////////////

//    /**
//     * 回滚积分
//     * @param queue
//     */
//    public boolean rollbackCredits(NotifyQueueDO queue){
//        String notifyUrl = appDAO.getAppByCache(queue.getAppId()).getCreditsConsumeNotifyUrl();
//        if(StringUtils.isBlank(notifyUrl)){
//            return false;
//        }
//        //查询扣积分订单交易状态
//        Map<String,Object> checkSubMap = checkSubCredits(queue,notifyUrl);
//        Integer type = (Integer) checkSubMap.get(HANDLER);
//
//        //如果订单失败或者是非减积分 不走通知
//        if(HandlerMannerEnum.END.getType() == type.intValue() || !Objects.equals(checkSubMap.get(TRADE_TYPE),"1")){
//            return true;
//        }else if(HandlerMannerEnum.RETRY.getType() == type.intValue()){
//            return false;
//        }
//
//        Integer score = (Integer) checkSubMap.get(SCORE);
//        String actCode = (String) checkSubMap.get(ACT_NAME);
//        //拼接记录参数
//        IcbcElifeRollbackCreditLogDO icbcElifeRollbackCreditLogDO = buildIcbcElifeRollbackCreditLog(actCode,queue);
//
//
//        //查询数据库是否有订单
//        HandlerMannerEnum checkRollback = verificationBizId(icbcElifeRollbackCreditLogDO, score, notifyUrl);
//        if(HandlerMannerEnum.END.getType() == checkRollback.getType()){
//            return true;
//        }else {
//            return false;
//        }
//    }

//    private HandlerMannerEnum verificationBizId(IcbcElifeRollbackCreditLogDO icbclog, long score, String notifyUrl){
//        try {
//            //先查，以前有没有加过，如果没加过，直接rollback 增加积分
//            IcbcElifeRollbackCreditLogDO ierbcl = icbcElifeRollbackCreditLogDAO.select(icbclog.getAppId(), icbclog.getOrderNum());
//            if(ierbcl == null){
//                //生成BizID
//                String uuid= UUID.randomUUID().toString().replaceAll("-","")+ "_" + icbclog.getOrderNum();
//                icbclog.setBizId(uuid);
//                //保存到数据库
//                icbclog.setIsAddCreditsSucess(false);
//                icbcElifeRollbackCreditLogDAO.insert(icbclog);
//                return addRollbackCredits(icbclog,String.valueOf(score),ADD_SCORE,notifyUrl);
//            }else{
//                if(ierbcl.getIsAddCreditsSucess()){
//                    return HandlerMannerEnum.END;
//                }
//                //起保护作用, 人为去订正
//                if(StringUtils.isBlank(icbclog.getBizId())){
//                    logger.error("bizId is null: {}" + JSONObject.toJSONString(icbclog));
//                    throw new BizException("bizId is null");
//                }
//                //check开发者有没有返还积分
//                HandlerMannerEnum checkhme = checkRollbackCredits(icbclog.getBizId(),notifyUrl);
//                if(HandlerMannerEnum.EXECUTE.getType() == checkhme.getType()){
//                    return addRollbackCredits(icbclog,String.valueOf(score),ADD_SCORE,notifyUrl);
//                }else {
//                    return checkhme;
//                }
//            }
//        }catch (Exception e){
//            logger.error(e.getMessage());
//            return HandlerMannerEnum.RETRY;
//        }
//    }



//    /**
//     * 查询 扣积分 交易状态 如果是异常失败的，等待下次重试，如果正常返回失败 删除记录。正常返回成功 继续验证
//     * @param queue
//     * @return
//     */
//    private Map<String,Object> checkSubCredits(NotifyQueueDO queue,String notifyUrl){
//        String result = checkCredits(queue.getDuibaOrderNum(),notifyUrl);
//        JSONObject jsonBody;
//        Map<String,Object> map = Maps.newHashMap();
//        try {
//            jsonBody = JSON.parseObject(result);
//            JSONObject jsonCheck = JsonTool.getAllJson(jsonBody);
//
//            if ("fail".equals(jsonCheck.getString(STATUS))) {
//                map.put(HANDLER,HandlerMannerEnum.END.getType());
//            } else {
//                map.put(SCORE,jsonCheck.getIntValue(SCORE));
//                map.put(ACT_NAME,jsonCheck.getString(ACT_NAME));
//                map.put(TRADE_TYPE,jsonCheck.getString(TRADE_TYPE));
//                map.put(STATUS,jsonCheck.getString(STATUS));
//                map.put(TRADE_ID,jsonCheck.getString(TRADE_ID));
//                map.put(HANDLER,HandlerMannerEnum.EXECUTE.getType());
//            }
//        } catch (Exception e) {
//            logger.error("rollbackCredits JSON.parseObject:", e);
//            map.put(HANDLER,HandlerMannerEnum.RETRY.getType());
//        }
//        return map;
//    }

//    /**
//     * 查询 返还积分 交易状态 如果是异常失败的，等待下次重试，如果正常返回成功 删除记录。正常返回失败 返还用户积分
//     * @param bizId
//     * @return
//     */
//    private HandlerMannerEnum checkRollbackCredits(String bizId, String notifyUrl){
//        String result = checkCredits(bizId,notifyUrl);
//        JSONObject jsonBody = null;
//        try {
//            jsonBody = JSON.parseObject(result);
//            JSONObject jsonCheck = JsonTool.getAllJson(jsonBody);
//            if ("success".equals(jsonCheck.getString(STATUS))) {
//                return HandlerMannerEnum.END;
//            } else {
//                return HandlerMannerEnum.EXECUTE;
//            }
//        } catch (Exception e) {
//            logger.error("rollbackCredits JSON.parseObject: {}", jsonBody,  e);
//            return HandlerMannerEnum.RETRY;
//        }
//    }


//    /**
//     * 查询交易状态
//     * @param orderNum
//     */
//    private String checkCredits(String orderNum,String notifyUrl){
//        String result = "";
//        try {
//            Map<String, String> authParams = Maps.newHashMap();
//            Map<String, String> dataParam = Maps.newHashMap();
//            //业务订单号
//            dataParam.put(TRADE_ID,orderNum);
//            authParams.put(APP_KEY,icbcElifeConfig.getAppKey());
//            authParams.put(ACCESS_TOKEN,"");
//            authParams.put(FORMAT,"json");
//            authParams.put(NAME,CHECK_SCORE);
//            authParams.put(VERSION,"1.0");
//            authParams.put(TIME_STAMP, DateUtils.getSecondStr(new Date()));
//            authParams.put(DATA,URLEncoder.encode(JSON.toJSONString(dataParam),"UTF-8"));
//            authParams.put(SIGN, IcbcSignTool.createSign(authParams,icbcElifeConfig.getAppSecret()));
//            result = doPost(authParams,orderNum,notifyUrl);
//        }catch (Exception e){
//            logger.error("icbcElife checkCredits error, result:{} ", result, e);
//        }
//        return result;
//    }

//    /**
//     * 扣除积分 用户回滚积分
//     * @param logDO
//     * @param score
//     * @param type
//     */
//    private HandlerMannerEnum addRollbackCredits(IcbcElifeRollbackCreditLogDO logDO,String score,String type,String notifyUrl){
//        int rollbackType = 1;
//        String result = "";
//        try {
//            Map<String, String> dataParam = Maps.newHashMap();
//            dataParam.put(ORDER_NUM,logDO.getBizId());
//            dataParam.put(UID,logDO.getPartnerUserId());
//            dataParam.put(CREDITS,score);
//            Map<String, String> authParams = buildAuthParams(dataParam, type, logDO.getActCode());
//            logDO.setRequestParam(JSON.toJSONString(authParams));
//
//            result = doPost(authParams,logDO.getOrderNum(),notifyUrl);
//
//            JSONObject jsonBody = JSON.parseObject(result);
//            JSONObject jsonCheck = JsonTool.getAllJson(jsonBody);
//            String status = jsonCheck.getString("code");
//            if ("0".equals(status)) {
//                rollbackType =  HandlerMannerEnum.END.getType();
//            } else {
//                rollbackType =  HandlerMannerEnum.RETRY.getType();
//            }
//        }catch (Exception e){
//            logger.error("icbcElife rollbackCredits error ",e);
//            result = e.getMessage();
//            rollbackType =  HandlerMannerEnum.RETRY.getType();
//        }
//
//        logDO.setResponseBody(result);
//        //保存积分记录
//        boolean isSucess = false;
//        if(rollbackType ==  HandlerMannerEnum.END.getType()){
//            isSucess = true;
//        }
//        saveAddCreditsLog(logDO,isSucess);
//
//        return HandlerMannerEnum.getByType(rollbackType);
//    }

//    private String doPost(Map<String, String> authParams,String orderNum,String notifyUrl){
//        String result ="";
//        HttpPost post = new HttpPost(notifyUrl);
////        HttpPost post = new HttpPost("http://29.100.152.66:8980/js/openapi");
//        List<NameValuePair> pairs = new ArrayList<>(authParams.size());
//        for (Map.Entry<String, String> entry : authParams.entrySet()) {
//            String value = entry.getValue();
//            if (value != null) {
//                pairs.add(new BasicNameValuePair(entry.getKey(), value));
//            }
//        }
//        post.setEntity(new UrlEncodedFormEntity(pairs, Charset.forName("UTF-8")));
//        try (CloseableHttpResponse response = httpClient.execute(post)) {
//            result = EntityUtils.toString(response.getEntity());
//            HttpRequestLog.logUrl("[action Credits-rollback][response bizId " + orderNum + "] [result " + result + "]");
//        } catch (Exception e) {
//            logger.info("工行卡定制积分回滚接口调用异常 orderNum={}", orderNum, e);
//            result = e.getMessage();
//        }
//        return result;
//    }
//
//    private IcbcElifeRollbackCreditLogDO buildIcbcElifeRollbackCreditLog(String actCode,NotifyQueueDO queue){
//        IcbcElifeRollbackCreditLogDO icbcElifeRollbackCreditLogDO = new IcbcElifeRollbackCreditLogDO();
//        icbcElifeRollbackCreditLogDO.setActCode(actCode);
//        icbcElifeRollbackCreditLogDO.setAppId(queue.getAppId());
//        icbcElifeRollbackCreditLogDO.setBizId(queue.getDeveloperBizId());
//        icbcElifeRollbackCreditLogDO.setConsumerId(queue.getConsumerId());
//        icbcElifeRollbackCreditLogDO.setOrderNum(queue.getDuibaOrderNum());
//        icbcElifeRollbackCreditLogDO.setPartnerUserId(queue.getPartnerUserId());
//        return icbcElifeRollbackCreditLogDO;
//    }

//    /**
//     * 定制  不管成功失败都返回bizId用于通知时，进行返还积分
//     * @param req
//     * @param resp
//     */
//    public void addIcbcElifeBizId(SubCreditsMsgWrapper req, SubCreditsResultMsgDto resp){
//        long appId = req.getSubCreditsMsg().getAppId();
//        if(!isIcbcApp(appId)){
//            return ;
//        }
//        String orderNum = req.getSubCreditsMsg().getCreditConsumeParams().getOrderNum();
//        if(StringUtils.isBlank(orderNum)){
//            return;
//        }
//        resp.setBizId(orderNum + "_ICBC");
//    }

//    private void saveAddCreditsLog(IcbcElifeRollbackCreditLogDO logDO, boolean isSucess) {
//        httpCallbackExecutorService.execute(() -> {
//            if(logDO == null){
//                return;
//            }
//            try {
//                //查询是否有记录
//                IcbcElifeRollbackCreditLogDO result = icbcElifeRollbackCreditLogDAO.select(logDO.getAppId(),logDO.getOrderNum());
//                logDO.setIsAddCreditsSucess(isSucess);
//                if(isSucess){
//                    logDO.setRecordSucessCount(1);
//                }
//                if(StringUtils.isNotBlank(logDO.getRequestParam()) && logDO.getRequestParam().length() > 500){
//                    logDO.setRequestParam(logDO.getRequestParam().substring(0, 500));
//                }
//                if(StringUtils.isNotBlank(logDO.getResponseBody()) && logDO.getResponseBody().length() > 1000){
//                    logDO.setResponseBody(logDO.getResponseBody().substring(0, 1000));
//                }
//                if(result == null){
//                    icbcElifeRollbackCreditLogDAO.insert(logDO);
//                }else{
//                    icbcElifeRollbackCreditLogDAO.update(logDO);
//                }
//            } catch (Exception e) {
//                logger.info("积分记录保存失败, bizId={}, orderNum={}", logDO.getBizId(), logDO.getOrderNum(), e);
//            }
//        });
//    }

    public boolean isIcbcApp(Long appId) {
        return null != appId && icbcElifeConfig.getAppIds().contains(appId);
    }


    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        String newUrl = url.substring(0, url.indexOf('?'));
        String queryString = url.substring(newUrl.length() + 1);
        // 1.将请求URL的参数转换为MAP
        Map<String, String> params = AssembleTool.getUrlParams(queryString);
        Map<String, String> extra = request.getParams();

        Map<String, String> data = new HashMap<>();
        data.put("couponCode", params.get("params"));
        data.put("customerId", extra.get("customerId"));
        data.put("mobile", extra.get("mobile"));
        data.put("outOrderNo", params.get("orderNum"));
        data.put("deductAmount", extra.get("amount"));
        data.put("customCouponName", extra.get("couponName"));

        String json = JSON.toJSONString(data);

        String encryptData;
        try {
            encryptData = RSAUtils.encodeByPublicKeyFormat(json, icbcElifeConfig.getPublicKey());
        } catch (Exception e) {
            throw new IllegalStateException(e);
        }

        Map<String, String> requestParams = new HashMap<>();
        requestParams.put("platformCode", icbcElifeConfig.getPlatformCode());
        requestParams.put("data", encryptData);

        String requestJson = JSON.toJSONString(requestParams);

        HttpPost httpPost = new HttpPost(newUrl);
        httpPost.setEntity(new StringEntity(requestJson, ContentType.APPLICATION_JSON));

        request.setHttpUrl(newUrl);
        request.setAuthParams(requestParams);

        return httpPost;
    }

    public String getVirtualResponse(SupplierRequest message, String body) {
        JSONObject result = new JSONObject();
        try {
            ResponeData responeData = JSON.parseObject(body, ResponeData.class);
            result.put("status", responeData.getCode() == 200 ? "success" : "fail");
            result.put("errorMessage", responeData.getMsg());
            if (responeData.getData() != null) {
                result.put("supplierBizId", responeData.getData().getCouponDetailNo());
            }
        } catch (Exception e) {
            logger.warn("icbc-elife 工行卡中心立减金发放结果解析失败", e);
            result.put("status", "fail");
            result.put("errorMessage", "开发者虚拟商品充值结果解析失败");
        }
        return result.toJSONString();
    }

    static class ResponeData {

        private int code;

        private String msg;

        private Data data;

        public int getCode() {
            return code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getMsg() {
            return msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public Data getData() {
            return data;
        }

        public void setData(Data data) {
            this.data = data;
        }
    }

    static class Data {

        private String couponDetailNo;

        public String getCouponDetailNo() {
            return couponDetailNo;
        }

        public void setCouponDetailNo(String couponDetailNo) {
            this.couponDetailNo = couponDetailNo;
        }
    }
}
