package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.constant.GeneraliChinaConfig;
import cn.com.duiba.domain.SupplierRequest;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Base64Utils;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

/**
 * @Date 2020/12/28
 * @Created by cmm
 */
@Service
public class GeneraliChinaApiStrategy implements ApiStrategy {

    private static final Logger log = LoggerFactory.getLogger(GeneraliChinaApiStrategy.class);

    @Autowired
    private GeneraliChinaConfig generaliChinaConfig;

    @Override
    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        HttpGet httpGet = new HttpGet(request.getHttpUrl());
        httpGet.addHeader("x-access-id", generaliChinaConfig.getAccessID());
        long currentTimeMillis = System.currentTimeMillis();
        String sign = generateSignature(generaliChinaConfig.getAccessID(), generaliChinaConfig.getAccessKey(), currentTimeMillis);
        httpGet.addHeader("x-signature", sign);
        httpGet.addHeader("x-request-send-timestamp", String.valueOf(currentTimeMillis));
        log.info("如意人寿accessID:{},accessKey,sign:{}",generaliChinaConfig.getAccessID(),generaliChinaConfig.getAccessKey(),sign);
        return httpGet;
    }
    public  String generateSignature(String accessId, String accessKey, long timestamp) {
        try {
            String key = Base64Utils.encodeToString(accessKey.getBytes("utf-8"));
            String signKey = accessId + "-" + timestamp;
            Mac hmacSha256 = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKey = new SecretKeySpec(key.getBytes
                    ("utf-8"), "HmacSHA256");
            hmacSha256.init(secretKey);
            return Base64Utils.encodeToString(hmacSha256.doFinal(signKey.getBytes("utf-8")));
        } catch (Exception e) {
            return null;
        }
    }
}

