package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.constant.HzUniteBankConfig;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.hzunitebank.RSAUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * @Date 2020/12/28
 * @Created by cmm
 * 杭州联合银行
 */
@Service
public class HzUniteBankApiStrategy implements ApiStrategy {

    private static final Logger log = LoggerFactory.getLogger(HzUniteBankApiStrategy.class);
    @Autowired
    private HzUniteBankConfig hzUniteBankConfig;

    @Override
    public HttpRequestBase getAddCreditsMessageRequest(CreditsMessageDto message) {
        Map<String, String> authParams = message.getAuthParams();
        String orderNo = authParams.get("orderNum");
        String time = DateUtils.getSecondStr(new Date());
        String remarks = authParams.get("description");
        String amount = authParams.get("credits");
        String extJson = message.getParams().get("extJson");
        if (StringUtils.isBlank(extJson) || JSON.parseObject(extJson).get("mobileNo") == null) {
            log.warn("杭州联合银行手机号获取异常orderId:{}", orderNo);
            throw new ThirdpatyException("杭州联合银行手机号获取异常");
        }
        String mobileNo = JSON.parseObject(extJson).getString("mobileNo");
        Map params = new HashMap();
        params.put("orderNo", orderNo);
        params.put("merchant", hzUniteBankConfig.getMerchant());
        params.put("mobileNo", mobileNo);
        params.put("time", time);
        params.put("amount", amount);
        params.put("remarks", remarks);
        StringBuffer b = new StringBuffer();
        b.append("orderNo=").append(orderNo).append("&").append("merchant=").append(hzUniteBankConfig.getMerchant())
                .append("&").append("mobileNo=").append(mobileNo).append("&").append("time=").append(time)
                .append("&").append("amount=").append(amount).append("&").append("remarks=").append(remarks);
        params.put("sign", RSAUtils.sign(hzUniteBankConfig.getPrivateKey(), b.toString()));
        log.info("杭州联合银行参数:{},", JSON.toJSONString(params));
        StringEntity stringEntity = new StringEntity(JSON.toJSONString(params), "UTF-8");
        HttpPost post = new HttpPost(message.getHttpUrl());
        post.addHeader("Content-Type", "application/json; charset=UTF-8");
        post.setEntity(stringEntity);
        return post;
    }

    @Override
    public String parseCreditsRsp(String body, Boolean addCredits, Map<String, String> authParams) {
        if (addCredits) {
            Map<String, String> map = new HashMap<>();
            JSONObject bodyJson = JSONObject.parseObject(body);
            String code = bodyJson.getString("code");
            if ("PY0000".equals(code)) {
                map.put("status", "ok");
            } else {
                map.put("status", "fail");
                map.put("errorMessage", bodyJson.getString("msg"));
            }
            return JSONObject.toJSONString(map);
        }
        return body;
    }
}
