package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.constant.JingDongConfig;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

/**
 * @author haojiahong
 * @date 2021-04-13
 */
@Service
public class JingDongApiStrategy implements ApiStrategy {

    private static final Logger LOGGER = LoggerFactory.getLogger(JingDongApiStrategy.class);


    @Autowired
    private JingDongConfig jingDongConfig;

    @Resource(name = "httpClient")
    @CanAccessInsideNetwork
    private CloseableHttpClient httpClient;


    public Boolean isJingDong(Long appId) {
        Set<Long> appIds = jingDongConfig.getConfigMap().keySet();
        if (CollectionUtils.isEmpty(appIds)) {
            return false;
        }
        return appIds.contains(appId);
    }

    @Override
    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {

        String url = message.getHttpUrl();
        String paramsStr = url.substring(url.indexOf('?') + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        Long appId = message.getSubCreditsMsg().getAppId();
        JingDongConfig.JingDongConfigBean jingDongConfigBean = jingDongConfig.getConfigMap().get(appId);

        Map<String, String> authParams = message.getSubCreditsMsg().getAuthParams();
        if (MapUtils.isEmpty(authParams)) {
            authParams = Maps.newHashMap();
        }
        authParams.put("uid", params.get("uid"));
        authParams.put("appId", appId + "");
        //京东这里，对应星速台的减积分ticketNum
        authParams.put("orderNum", params.get("orderNum"));
        authParams.put("appKey", params.get("appKey"));
        authParams.put("appSecret", message.getSubCreditsMsg().getAppSecret());
        authParams.put("shopId", jingDongConfigBean.getShopId() + "");
        authParams.put("venderId", jingDongConfigBean.getVenderId() + "");
        message.getSubCreditsMsg().setAuthParams(authParams);

        HttpPost httpPost = new HttpPost(JingDongConfig.Api.CONSUMER_POINTS.getApiAbsolutePath(jingDongConfig));
        Map<String, String> map = Maps.newHashMap();
        //防重id
        map.put("businessId", params.get("orderNum"));
        //积分
        Integer credits = Integer.valueOf(params.get("credits"));
        map.put("points", -credits + "");
        map.put("desc", params.get("description"));
        map.put("uid", params.get("uid"));
        map.put("shopId", jingDongConfigBean.getShopId() + "");
        map.put("venderId", jingDongConfigBean.getVenderId() + "");
        addSign(params.get("appKey"), message.getSubCreditsMsg().getAppSecret(), map);

        StringEntity stringEntity = new StringEntity(JSON.toJSONString(map), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity(stringEntity);

        LOGGER.info("京东减积分，req={}", JSON.toJSONString(map));
        return httpPost;
    }

    private void addSign(String appKey, String appSecret, Map<String, String> paramMap) {
        paramMap.put("appKey", appKey);
        paramMap.put("appSecret", appSecret);
        if (paramMap.get("timestamp") == null) {
            paramMap.put("timestamp", String.valueOf(System.currentTimeMillis()));
        }
        String sign = SignTool.sign(paramMap);
        paramMap.put("sign", sign);
        paramMap.remove("appSecret");
    }


    @Override
    public String parseCreditsRsp(String body, Boolean addCredits, Map<String, String> authParams) {
        if (addCredits) {
            LOGGER.info("京东加积分，resp={}", body);
        } else {
            LOGGER.info("京东减积分，resp={}", body);
        }
        Map<String, String> map = Maps.newHashMap();
        if (StringUtils.isBlank(body)) {
            map.put("status", "fail");
            map.put("errorMessage", "京东新增/扣减积分接口返回为空");
            return JSON.toJSONString(map);
        }
        try {
            JSONObject jsonObject = JSONObject.parseObject(body);
            Boolean success = jsonObject.getBoolean("data");
            String desc = jsonObject.getString("desc");
            if (success) {
                map.put("status", "ok");
                map.put("bizId", authParams.get("orderNum"));
                map.put("credits", String.valueOf(getCredits(authParams.get("uid"), authParams.get("venderId"),
                        authParams.get("shopId"), authParams.get("appKey"), authParams.get("appSecret"))));
            } else {
                map.put("status", "fail");
                String errorMsg = desc;
                if (StringUtils.isBlank(errorMsg)) {
                    errorMsg = "积分不足";
                }
                if (StringUtils.length(errorMsg) > 255) {
                    errorMsg = errorMsg.substring(0, 255);
                }
                map.put("errorMessage", errorMsg);
            }
        } catch (Exception e) {
            LOGGER.error("京东新增/扣减积分接口解析错误:{}--是否新增:{}", body, addCredits, e);
            map.put("status", "fail");
            map.put("errorMessage", "京东新增/扣减积分解析结果错误");
        }
        LOGGER.info("京东加减积分定制返回，map={}", JSON.toJSONString(map));
        return JSONObject.toJSONString(map);
    }

    @Override
    public HttpRequestBase getAddCreditsMessageRequest(CreditsMessageDto message) {
        //暂时不需要加积分功能
        return null;
    }

    @Override
    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record) {
        return null;
    }


    public Long getCredits(String uid, String venderId, String shopId, String appkey, String appSecret) {
        String url = JingDongConfig.Api.GET_CUSTOMER_POINTS.getApiAbsolutePath(jingDongConfig);

        Map<String, String> params = Maps.newHashMap();
        params.put("uid", uid);
        params.put("venderId", venderId);
        params.put("shopId", shopId);
        addSign(appkey, appSecret, params);

        LOGGER.info("京东查询积分，req={}", JSON.toJSONString(params));
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity(new StringEntity(JSON.toJSONString(params), ContentType.APPLICATION_JSON));

        String resp;
        try (CloseableHttpResponse response = httpClient.execute(httpPost)) {
            HttpEntity entity = response.getEntity();
            resp = EntityUtils.toString(entity, "UTF-8");
        } catch (IOException e) {
            LOGGER.warn("京东，查询积分，异常，url={}", url, e);
            throw new ThirdpatyException("京东，查询积分，异常");
        }
        LOGGER.info("京东查询积分，resp={}", resp);
        if (StringUtils.isBlank(resp)) {
            throw new ThirdpatyException("京东查询积分失败");
        }
        Boolean flag = JSON.parseObject(resp).getBoolean("success");
        if (!BooleanUtils.isTrue(flag)) {
            throw new ThirdpatyException("京东查询积分失败");
        }
        Long credits = JSON.parseObject(resp).getLong("data");
        if (credits == null) {
            throw new ThirdpatyException("京东查询积分失败");
        }
        return credits;
    }


}
