package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.biz.tool.duiba.util.SHA256Util;
import cn.com.duiba.constant.PingAnLifeInsuranceConfig;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;
import cn.com.duiba.tool.AssembleTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;

/**
 * @ClassName PingAnLifeInsuranceStrategy
 * @Description
 * @Author liheping
 * @Date 2021/7/26
 **/

@Service
public class PingAnLifeInsuranceStrategy implements ApiStrategy {

    private static final Logger LOGGER = LoggerFactory.getLogger(PingAnLifeInsuranceStrategy.class);

    private static final String LOG_PRE = "平安人寿";

    @Autowired
    private PingAnLifeInsuranceConfig pingAnLifeInsuranceConfig;

    @Autowired
    private AppDAO appDAO;


    @Override
    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        LOGGER.info(LOG_PRE + "扣积分默认请求message={}", JSONObject.toJSONString(message));

        String url = message.getHttpUrl();
        String paramsStr = url.substring(url.indexOf('?') + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        //请求参数
        Map<String, String> authParams = message.getSubCreditsMsg().getAuthParams();
        if (MapUtils.isEmpty(authParams)) {
            authParams = Maps.newHashMap();
        }
        authParams.remove("sign");
        String sign = SHA256Util.sha256Sign(authParams);
        LOGGER.info(LOG_PRE + "扣积分请求sha256加密sign={},authParams={}", sign, JSONObject.toJSONString(authParams));
        authParams.put("sign", sign);

        params.remove("sign");
        params.put("appSecret", message.getSubCreditsMsg().getAppSecret());
        String newSign = SHA256Util.sha256Sign(params);
        LOGGER.info(LOG_PRE + "扣积分请求sha256加密newSign={}，params={}", newSign, JSONObject.toJSONString(params));
        params.put("sign", newSign);
        params.remove("appSecret");
        String httpUrl = AssembleTool.assembleUrl(message.getSubCreditsMsg().getCreditsConsumeRequestUrl(), params);
        message.setHttpUrl(httpUrl);
        message.getSubCreditsMsg().setAuthParams(authParams);
        return null;
    }

    @Override
    public String parseCreditsRsp(String body, Boolean addCredits, Map<String, String> authParams) {
        LOGGER.info(LOG_PRE + "扣积分响应body=" + body);
        if (addCredits) {
            LOGGER.info("{}-加积分响应，resp={}", LOG_PRE, body);
        } else {
            LOGGER.info("{}-减积分响应，resp={}", LOG_PRE, body);
        }
        Map<String, String> map = Maps.newHashMap();
        if (StringUtils.isBlank(body)) {
            map.put("status", "fail");
            map.put("errorMessage", LOG_PRE + "新增/扣减积分接口返回为空");
            return JSON.toJSONString(map);
        }
        return body;
    }


    @Override
    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record) {
        LOGGER.info(LOG_PRE + "获取兑换结果通知 :{}，url:{}", JSON.toJSONString(record), notifyUrl);
        Map<String, String> map = getRequestMap(record);
        HttpRequestBase request;
        request = new HttpGet(AssembleTool.assembleUrl(notifyUrl, map));
        return request;

    }

    public Map<String, String> getRequestMap(NotifyQueueDO record) {
        AppDO app = appDAO.getAppByCache(record.getAppId());
        if (null == app) {
            throw new IllegalStateException("app info为空");
        }
        Map<String, String> map = new HashMap(10);
        map.put("success", record.getResult() + "");
        map.put("errorMessage", record.getError4developer());
        map.put("bizId", record.getDeveloperBizId());
        map.put("appKey", app.getAppKey());
        map.put("timestamp", System.currentTimeMillis() + "");
        map.put("uid", record.getPartnerUserId());
        map.put("orderNum", record.getDuibaOrderNum());
        map.put("appSecret", appDAO.getAppSecret(app));
        String sign = SHA256Util.sha256Sign(map);
        LOGGER.info(LOG_PRE + "通知请求sha256加密sign={}，params={}", sign, JSONObject.toJSONString(map));
        map.remove("appSecret");
        map.put("sign", sign);
        return map;
    }

}
