package cn.com.duiba.constant;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Configuration;

import java.util.Set;

/**
 * @author JunAngLiu
 * @Title: ErweihuoConfig
 * @Description: 二维火 常量
 * @date 2019/10/914:38
 */

@Configuration
@RefreshScope
public class ErweihuoConfig {

    @Value("${erweihuo.appIds}")
    private Set<Long> appIds;

    //调用减积分API的服务方法
    @Value("${erweihuo.subCreditsMethod}")
    private String subCreditsMethod;

    //调用加积分API的服务方法
    @Value("${erweihuo.addCreditsMethod}")
    private String addCreditsMethod;
    //查询积分接口
    @Value("${erweihuo.queryCreditsMethod}")
    private String queryCreditsMethod;

    @Value("${erweihuo.appKey}")
    private String appKey;

    @Value("${erweihuo.appSecret}")
    private String appSecret;

    //前台发生门店ID
    @Value("${erweihuo.shopEntityId}")
    private String shopEntityId;

    //店铺ID，连锁总店ID
    @Value("${erweihuo.entityId}")
    private String entityId;

    //版本号
    @Value("${erweihuo.version}")
    private String version;

    //环境
    @Value("${erweihuo.env}")
    private String env;


    public Set<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }

    public String getSubCreditsMethod() {
        return subCreditsMethod;
    }

    public void setSubCreditsMethod(String subCreditsMethod) {
        this.subCreditsMethod = subCreditsMethod;
    }

    public String getAddCreditsMethod() {
        return addCreditsMethod;
    }

    public void setAddCreditsMethod(String addCreditsMethod) {
        this.addCreditsMethod = addCreditsMethod;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public String getShopEntityId() {
        return shopEntityId;
    }

    public void setShopEntityId(String shopEntityId) {
        this.shopEntityId = shopEntityId;
    }

    public String getEntityId() {
        return entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getEnv() {
        return env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public String getQueryCreditsMethod() {
        return queryCreditsMethod;
    }

    public void setQueryCreditsMethod(String queryCreditsMethod) {
        this.queryCreditsMethod = queryCreditsMethod;
    }
}
