package cn.com.duiba.constant;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zyj
 * @date 2018/12/12
 */
@Component
@RefreshScope
public class EzrConstant {

    /**
     * 对接过ezr的appIds
     */
    @Value("${ezr.appIds}")
    private String appIds;

    /**
     * 特步的token
     */
    @Value("${ezr.xtep.token}")
    private String xtepToken;

    /**
     * 特步的appId,注意:此appId为ezr平台的appId,非兑吧的
     */
    @Value("${ezr.xtep.appId}")
    private String xtepAppId;

    /**
     * 特步的appSystem
     */
    @Value("${ezr.xtep.appSystem}")
    private String xtepAppSystem;


    /**
     * 特步的ShopCode
     */
    @Value("${ezr.xtep.ShopCode}")
    private String xtepShopCode;


    public List<Long> getAppIds() {

        if(StringUtils.isBlank(appIds)){
            return Collections.emptyList();
        }
        //转换成Long
        return Arrays.asList(appIds.split(",")).stream().map(Long::valueOf).collect(Collectors.toList());
    }

    public String getXtepToken() {
        return xtepToken;
    }

    public String getXtepAppId() {
        return xtepAppId;
    }

    public String getXtepAppSystem() {
        return xtepAppSystem;
    }

    public String getXtepShopCode() {
        return xtepShopCode;
    }
}
