package cn.com.duiba.constant;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;


/**
 * @Author fengjun
 * @Date 2019-10-30
 * @Email: fengjun@duiba.com.cn
 * @Description:
 */

@Configuration
@ConfigurationProperties(prefix = "app.pingan.card")
public class PinganCardConfig {

    /**
     * 平安卡中心-appid
     */
    private String appId;
    //发金币url要带问号
    //@Value("${app.pingan.card.url.giveCoins}")
    //private String giveCoinsUrl;

    private String channel;

    private String accessTokenUrl;

    private String thirdPart;
    private String interfaceKey;

    private String privateKey;

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getPrivateKey() {
        return privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    /*public String getGiveCoinsUrl() {
        return giveCoinsUrl;
    }

    public void setGiveCoinsUrl(String giveCoinsUrl) {
        this.giveCoinsUrl = giveCoinsUrl;
    }
*/
    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getAccessTokenUrl() {
        return accessTokenUrl;
    }

    public void setAccessTokenUrl(String accessTokenUrl) {
        this.accessTokenUrl = accessTokenUrl;
    }

    public String getThirdPart() {
        return thirdPart;
    }

    public void setThirdPart(String thirdPart) {
        this.thirdPart = thirdPart;
    }

    public String getInterfaceKey() {
        return interfaceKey;
    }

    public void setInterfaceKey(String interfaceKey) {
        this.interfaceKey = interfaceKey;
    }

    private List<Long> appIdList;

    public List<Long> getAppIds() {

        if (StringUtils.isBlank(appId)) {
            return Collections.emptyList();
        }
        if (CollectionUtils.isEmpty(appIdList)) {
            appIdList = Arrays.stream(appId.split(",")).map(Long::valueOf).collect(Collectors.toList());
        }
        return appIdList;
    }
}
