package cn.com.duiba.constant;

import com.google.common.collect.Sets;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Set;

/**
 * Created by sunyan on 2020/1/16.
 */
@Configuration
@ConfigurationProperties(prefix = "suning")
public class SuningConfig {
    private Set<Long> appIds = Sets.newHashSet(70080L);

    /**
     * 苏宁开放平台商户id
     */
    private String openAppId;

    /**
     * 公钥索引
     */
    private String signkeyIndex;

    /**
     * 兑吧私钥
     */
    private String duibaPrivateKey;

    /**
     * 苏宁公钥
     */
    private String suningPublicKey;
    /**
     * acekey
     */
    private String duibaAesKey;

    /**
     * 用户信息查询接口
     */
    private String userInfoUrl;

    /**
     * 扣积分接口
     */
    private String deductionUrl;

    /**
     * 虚拟商品接口
     */
    private String virtualUrl;

    private String grantSource = "FSGSMMSQ";

    public String getGrantSource() {
        return grantSource;
    }

    public void setGrantSource(String grantSource) {
        this.grantSource = grantSource;
    }

    public Set<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }

    public String getOpenAppId() {
        return openAppId;
    }

    public void setOpenAppId(String openAppId) {
        this.openAppId = openAppId;
    }

    public String getSignkeyIndex() {
        return signkeyIndex;
    }

    public void setSignkeyIndex(String signkeyIndex) {
        this.signkeyIndex = signkeyIndex;
    }

    public String getDuibaPrivateKey() {
        return duibaPrivateKey;
    }

    public void setDuibaPrivateKey(String duibaPrivateKey) {
        this.duibaPrivateKey = duibaPrivateKey;
    }

    public String getSuningPublicKey() {
        return suningPublicKey;
    }

    public void setSuningPublicKey(String suningPublicKey) {
        this.suningPublicKey = suningPublicKey;
    }

    public String getUserInfoUrl() {
        return userInfoUrl;
    }

    public void setUserInfoUrl(String userInfoUrl) {
        this.userInfoUrl = userInfoUrl;
    }

    public String getDeductionUrl() {
        return deductionUrl;
    }

    public void setDeductionUrl(String deductionUrl) {
        this.deductionUrl = deductionUrl;
    }

    public String getDuibaAesKey() {
        return duibaAesKey;
    }

    public void setDuibaAesKey(String duibaAesKey) {
        this.duibaAesKey = duibaAesKey;
    }

    public String getVirtualUrl() {
        return virtualUrl;
    }

    public void setVirtualUrl(String virtualUrl) {
        this.virtualUrl = virtualUrl;
    }
}
