package cn.com.duiba.constant;

import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.biz.credits.strategy.Impl.TailongApiStrategy;
import com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import java.util.Set;

/**
 * cmm
 **/
@Configuration
@ConfigurationProperties(prefix = "tailongBank")
public class TailongBankConfig  implements InitializingBean {

    private static final Logger log = LoggerFactory.getLogger(TailongBankConfig.class);

    @Autowired
    private TailongApiStrategy tailongApiStrategy;

    /**
     * 应用id集合
     */
    private Set<Long> appIdSet = Sets.newHashSet(19446L);

    /**
     * 金融云分配给商户的应用Id
     */
    private String mechNo = "7428f510-4187-4169-b359-a9295fcc6b23";
    /**
     * 金融云分配给商户的名称
     */
    private String mechName = "duiba";

    private String virtualCreditsPre = "TLYH_";

    private String otpCodeRedisKey = "HASH:TAILONG:OTPCODE";
    //存放用户token的key，类型从hash改为string
    private String otpCodeStringRedisKey = "STR:TAILONG:OTPCODE:";
    //泰隆请求接口用的accesstoken
    private String accessTokenRedisKey = "Str:TAILONG:ACCESS_TOKEN";

    //泰隆银行服务请求地址
    private  String tlHttpUrl = "https://mouldai.com/apiSIT/duiba/";
    //商户appID
    private  String mechAppID = "7428f510-4187-4169-b359-a9295fcc6b23";
    //加密秘钥，注意存储，防止泄露
    private  String appSecretKey = "d23b90de-63ae-4325-bf77-7cfa38cac1ef";

    //    //自有私钥，安全保存，防止泄露
    private  String sm2PrivateKey = "MIGTAgEAMBMGByqGSM49AgEGCCqBHM9VAYItBHkwdwIBAQQgG9IbK5uambvQpn7A47CvmZVbjyD054WVMU/PuB1vje2gCgYIKoEcz1UBgi2hRANCAATe8Z/6BFSMDnIppQUYhbB7B/6Gh7rwXakCQmLs2pMjl587D8SiKdq2HRTRFCIu57uYAU75MfLMfTV6ODUfasVJ";
    //自有公钥，提供给银行，
    private  String sm2PublicKey = "MFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAE3vGf+gRUjA5yKaUFGIWwewf+hoe68F2pAkJi7NqTI5efOw/Eoinath0U0RQiLue7mAFO+THyzH01ejg1H2rFSQ==";
    //泰隆银行生成提供的公钥
    private  String tlPublicKey = "MFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAE/knoPfu5Dyzevnuxt/W8R3KGZuvzCJz5CTAJkqoWepnpjI2Ar5Q4Ba8y0Qo0WXmUPOd8IQ/kDEPqe43fMtErCg==";

    private   Long INTERVALTIME = 3540L;



    public String getMechNo() {
        return mechNo;
    }

    public void setMechNo(String mechNo) {
        this.mechNo = mechNo;
    }

    public String getMechName() {
        return mechName;
    }

    public void setMechName(String mechName) {
        this.mechName = mechName;
    }

    public String getOtpCodeRedisKey() {
        return otpCodeRedisKey;
    }

    public void setOtpCodeRedisKey(String otpCodeRedisKey) {
        this.otpCodeRedisKey = otpCodeRedisKey;
    }

    public Set<Long> getAppIdSet() {
        return appIdSet;
    }

    public void setAppIdSet(Set<Long> appIdSet) {
        this.appIdSet = appIdSet;
    }

    public String getAccessTokenRedisKey() {
        return accessTokenRedisKey;
    }

    public void setAccessTokenRedisKey(String accessTokenRedisKey) {
        this.accessTokenRedisKey = accessTokenRedisKey;
    }

    public String getTlHttpUrl() {
        return tlHttpUrl;
    }

    public void setTlHttpUrl(String tlHttpUrl) {
        this.tlHttpUrl = tlHttpUrl;
    }


    public String getAppSecretKey() {
        return appSecretKey;
    }

    public void setAppSecretKey(String appSecretKey) {
        this.appSecretKey = appSecretKey;
    }

    public String getSm2PrivateKey() {
        return sm2PrivateKey;
    }

    public void setSm2PrivateKey(String sm2PrivateKey) {
        this.sm2PrivateKey = sm2PrivateKey;
    }

    public String getSm2PublicKey() {
        return sm2PublicKey;
    }

    public void setSm2PublicKey(String sm2PublicKey) {
        this.sm2PublicKey = sm2PublicKey;
    }

    public String getTlPublicKey() {
        return tlPublicKey;
    }

    public void setTlPublicKey(String tlPublicKey) {
        this.tlPublicKey = tlPublicKey;
    }

    public Long getINTERVALTIME() {
        return INTERVALTIME;
    }

    public void setINTERVALTIME(Long INTERVALTIME) {
        this.INTERVALTIME = INTERVALTIME;
    }

    public String getMechAppID() {
        return mechAppID;
    }

    public void setMechAppID(String mechAppID) {
        this.mechAppID = mechAppID;
    }

    public String getVirtualCreditsPre() {
        return virtualCreditsPre;
    }

    public void setVirtualCreditsPre(String virtualCreditsPre) {
        this.virtualCreditsPre = virtualCreditsPre;
    }

    public String getOtpCodeStringRedisKey() {
        return otpCodeStringRedisKey;
    }

    public void setOtpCodeStringRedisKey(String otpCodeStringRedisKey) {
        this.otpCodeStringRedisKey = otpCodeStringRedisKey;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        log.info("开始注册策略---------");
        ApiStrategyRouter.register(appIdSet, tailongApiStrategy);
    }
}

