package cn.com.duiba.constant;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Map;

/**
 * @author qiurenjie
 * @date 2021-07-16 15:20
 */
@Configuration
@ConfigurationProperties(prefix = "virtual.fulu")
public class VirtualFuLuConfig implements InitializingBean {

    //app主体对应的密钥
    private String appConfigBySubject;
    private Map<String, Object> appConfigBySubjectMap = Maps.newHashMap();
    //请求域名
    private String url = "http://pre.openapi.fulu.com/api/getway";

    @Override
    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isNotBlank(appConfigBySubject)) {
            appConfigBySubjectMap = JSON.parseObject(appConfigBySubject);
        }
    }

    public enum Api {
        /**
         * 直充下单接口
         */
        ORDER_DIRECT_ADD("fulu.order.direct.add"),
        /**
         * 订单查询接口
         */
        ORDER_INFO_GET("fulu.order.info.get"),
        /**
         * 话费充值接口
         */
        ORDER_MOBILE_GET("fulu.order.info.get"),
        ;

        String methodName;

        Api(String methodName) {
            this.methodName = methodName;
        }

        public String getMethodName() {
            return methodName;
        }
    }

    public String getAppConfigBySubject() {
        return appConfigBySubject;
    }

    public void setAppConfigBySubject(String appConfigBySubject) {
        this.appConfigBySubject = appConfigBySubject;
    }

    public Map<String, Object> getAppConfigBySubjectMap() {
        return appConfigBySubjectMap;
    }

    public void setAppConfigBySubjectMap(Map<String, Object> appConfigBySubjectMap) {
        this.appConfigBySubjectMap = appConfigBySubjectMap;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

}
