package cn.com.duiba.constant;

import cn.com.duiba.constant.base.BaseUnionBankConstants;
import com.google.common.collect.ImmutableSet;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Set;

@Configuration
@ConfigurationProperties(prefix = "zc.union.bank")
public class ZCUnionBankConstants implements BaseUnionBankConstants {
    private Set<Long> appIdSet = ImmutableSet.of(70195L);

    /**
     * 前缀
     */
    private String virtualCreditsPre = "unionPayCoupon_zc_";

    /**
     * 虚拟商品请求地址
     */
    private String virtualUrl = "https://open.95516.com/open/access/1.0/maktg.draw";

    public Set<Long> getAppIdSet() {
        return appIdSet;
    }

    public void setAppIdSet(Set<Long> appIdSet) {
        this.appIdSet = appIdSet;
    }

    @Override
    public String getVirtualCreditsPre() {
        return virtualCreditsPre;
    }

    public void setVirtualCreditsPre(String virtualCreditsPre) {
        this.virtualCreditsPre = virtualCreditsPre;
    }

    @Override
    public String getVirtualUrl() {
        return virtualUrl;
    }

    public void setVirtualUrl(String virtualUrl) {
        this.virtualUrl = virtualUrl;
    }
}
