package cn.com.duiba.dao;

import java.util.List;

import cn.com.duiba.domain.HttpMessageDO;

/**
 * HTTP异常重试DAO
 */
public interface HttpMessageDAO {
	
	/**
	 * 查询
	 * @param id
	 * @return
	 */
	public HttpMessageDO find(Long id);
	
	/**
	 * 添加
	 * @param message
	 */
	public void insert(HttpMessageDO message);
	
	/**
	 * 修改下次重试时间
	 * @param id
	 * @param nextOffset
	 * @return
	 */
	public int updateNextTime(long id, int nextOffset);
	
	/**
	 * 删除
	 * @param id
	 * @return
	 */
	public int delete(Long id);
	
	/**
	 * 根据类型查询需要重试的数据
	 * @param bizType
	 * @param limit
	 * @return
	 */
	public List<HttpMessageDO> findNeedRetry(String bizType, int limit);
	
}
