package cn.com.duiba.dao.impl;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

import cn.com.duiba.constant.DatabaseSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.dao.BaseDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duiba.wolf.utils.BlowfishUtils;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;

/**
 * APP查询
 */
@Repository("appDAO")
public class AppDAOImpl extends BaseDAO implements AppDAO {

	private static Logger log = LoggerFactory.getLogger(AppDAOImpl.class);

	@Value("${app.secret.key}")
	private String appSecretKey;

	private Cache<Long, AppDO> appCache = CacheBuilder.newBuilder().expireAfterWrite(1, TimeUnit.MINUTES).build();

	@Override
	public AppDO findAppSimple(Long id) {
		return getSqlSession().selectOne(getStamentNameSpace("findAppSimple"), id);
	}

	@Override
	public String getAppSecret(AppDO app) {
		return BlowfishUtils.decryptBlowfish(app.getSecretCode(), appSecretKey);
	}

	/**
	 * getAppSecretKey
	 * @return
	 */
	public String getAppSecretKey() {
		return appSecretKey;
	}

	/**
	 * setAppSecretKey
	 * @param appSecretKey
	 */
	public void setAppSecretKey(String appSecretKey) {
		this.appSecretKey = appSecretKey;
	}

	@Override
	public AppDO getAppByCache(final Long appId) {
		try {
			DBTimeProfile.enter("getAppByLocalCache");
			return appCache.get(appId, new Callable<AppDO>() {

				@Override
				public AppDO call() throws Exception {
					return findAppSimple(appId);
				}

			});
		} catch (Exception e) {
			log.error("getAppByCache error", e);
			return findAppSimple(appId);
		} finally {
			DBTimeProfile.release();
		}
	}

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.CREDITS;
	}
}
