package cn.com.duiba.remoteimpl;

import cn.com.duiba.biz.credits.SubVirtualCurrencyToDeveloper;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.thirdparty.api.RemoteVirtualCurrencyService;
import cn.com.duiba.thirdparty.dto.VirtualCurrencyMessage;
import cn.com.duiba.tool.CodeException;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

/**
 * @program: thirdparty-all
 * @description: 扣虚拟货币服务
 * @author: Simba
 * @create: 2019-03-15 14:30
 **/
@RestController
public class RemoteVirtualCurrencyServiceImpl implements RemoteVirtualCurrencyService {

    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;
    @Autowired
    private SubVirtualCurrencyToDeveloper subVirtualCurrencyToDeveloper;

    @Override
    public void submitSubVirtualCurrency(VirtualCurrencyMessage request, String callbackTopic, String msgTag, String msgKey) {
        validate(request, callbackTopic);
        subVirtualCurrencyToDeveloper.submit(request, callbackTopic, msgTag, msgKey, null, 0);
    }

    /**
     * 验证提交请求
     *
     * @param request
     * @param callbackTopic
     * @throws CodeException
     */
    private void validate(VirtualCurrencyMessage request, String callbackTopic) throws CodeException {
        if (StringUtils.isEmpty(callbackTopic)) {
            throw new CodeException("0", "订阅Topic不能为空");
        }
        if (StringUtils.isEmpty(request.getHttpUrl())) {
            throw new CodeException("0", "请求URL不能为空");
        }
        if (request.getAppId() == null) {
            throw new CodeException("0", "APPID不能为空");
        }
        if (!httpAsyncClientPool.canSubmitToAppPool(request.getAppId())) {
            throw new CodeException("0", "开发者接口繁忙, appId: " + request.getAppId());
        }
    }
}

