package cn.com.duiba.tool.cgb;

import java.io.InputStream;
import java.security.MessageDigest;

/**
 * @Author: lufeng
 * @Description:
 * @Date: Created in 2020/6/16
 */
public class MD5 {

    public static String getMD5(String fileName) throws Exception {
        InputStream fi = null;
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            fi = CgbSign.getInputStream(fileName);
            byte[] buffer=new byte[8192];
            int length;
            while((length=fi.read(buffer))!=-1) {
                md5.update(buffer, 0, length);
            }

            byte tmp[] = md5.digest();
            return MD5.byte2hex(tmp);
        }catch(Exception e) {
            throw e;
        } finally {
            if (fi != null) fi.close();
        }
    }

    public static String getStringMD5(String str) throws Exception {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");

            String path=MD5.class.getClassLoader().getResource("").getPath();
            md5.update(str.getBytes());

            byte tmp[] = md5.digest();
            return MD5.byte2hex(tmp);
        }catch(Exception e) {
            throw e;
        }
    }

    public static String byte2hex(byte[] b) {
        StringBuffer hs = new StringBuffer();
        String stmp;
        for (int i = 0; i < b.length; i++) {
            stmp = Integer.toHexString(b[i] & 0xFF).toUpperCase();
            if (stmp.length() == 1) {
                hs.append("0").append(stmp);
            } else {
                hs.append(stmp);
            }
        }
        return hs.toString();
    }
}
