package cn.com.duiba.tool.sn;

import java.io.UnsupportedEncodingException;

public class SMS4Util {

    public static byte[] encodeSMS4(String plaintext, byte[] key) {
        if (plaintext == null || plaintext.equals("")) {
            return null;
        }
        for (int i = plaintext.getBytes().length % 16; i < 16; i++) {
            plaintext += "\0";
        }

        return encodeSMS4(plaintext.getBytes(), key);
    }

    /**
     * 不限明文长度的SMS4加密
     *
     * @param plaintext
     * @param key
     * @return
     */
    public static byte[] encodeSMS4(byte[] plaintext, byte[] key) {
        byte[] ciphertext = new byte[plaintext.length];

        int k = 0;
        int plainLen = plaintext.length;
        while (k + 16 <= plainLen) {
            byte[] cellPlain = new byte[16];
            for (int i = 0; i < 16; i++) {
                cellPlain[i] = plaintext[k + i];
            }
            byte[] cellCipher = encode16(cellPlain, key);
            for (int i = 0; i < cellCipher.length; i++) {
                ciphertext[k + i] = cellCipher[i];
            }

            k += 16;
        }

        return ciphertext;
    }

    /**
     * 不限明文长度的SMS4解密
     *
     * @param ciphertext
     * @param key
     * @return
     */
    public static byte[] decodeSMS4(byte[] ciphertext, byte[] key) {
        byte[] plaintext = new byte[ciphertext.length];

        int k = 0;
        int cipherLen = ciphertext.length;
        while (k + 16 <= cipherLen) {
            byte[] cellCipher = new byte[16];
            for (int i = 0; i < 16; i++) {
                cellCipher[i] = ciphertext[k + i];
            }
            byte[] cellPlain = decode16(cellCipher, key);
            for (int i = 0; i < cellPlain.length; i++) {
                plaintext[k + i] = cellPlain[i];
            }

            k += 16;
        }

        return plaintext;
    }

    /**
     * 解密，获得明文字符串
     *
     * @param ciphertext
     * @param key
     * @return
     */
    public static String decodeSMS4toString(byte[] ciphertext, byte[] key) {
        byte[] plaintext = decodeSMS4(ciphertext, key);
        String plain = new String(plaintext);
        return plain.trim();
    }

    /**
     * 只加密16位明文
     *
     * @param plaintext
     * @param key
     * @return
     */
    private static byte[] encode16(byte[] plaintext, byte[] key) {
        byte[] cipher = new byte[16];
        SMS4 sm4 = new SMS4();
        int ENCRYPT = 1;
        sm4.sms4(plaintext, 16, key, cipher, ENCRYPT);

        return cipher;
    }

    /**
     * 只解密16位密文
     *
     * @param ciphertext
     * @param key
     * @return
     */
    private static byte[] decode16(byte[] ciphertext, byte[] key) {
        byte[] plain = new byte[16];
        SMS4 sm4 = new SMS4();
        int DECRYPT = 0;
        sm4.sms4(ciphertext, 16, key, plain, DECRYPT);

        return plain;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        // 密钥
        byte[] key = { 0x01, 0x23, 0x45, 0x67, (byte) 0x89, (byte) 0xab,
                (byte) 0xcd, (byte) 0xef, (byte) 0xfe, (byte) 0xdc,
                (byte) 0xba, (byte) 0x98, 0x76, 0x54, 0x32, 0x10 };
        System.out.println(new String(key));

        String newString = "Coding1231"; // 明文

        byte[] enOut = SMS4Util.encodeSMS4(newString, key);
        if (enOut == null) {
            return;
        }

        System.out.println("加密结果：" + new String(enOut));
        ;

        byte[] deOut = SMS4Util.decodeSMS4(enOut, key);
        System.out.println("解密结果(return byte[])" + new String(deOut));


        String deOutStr = SMS4Util.decodeSMS4toString(enOut, key);
        System.out.println("解密结果(return String)：" + deOutStr);
    }
}
