package cn.com.duiba.biz.credits;

import cn.com.duiba.constant.BaofengConfig;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.JsonTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * @author hao.wong
 * @date 2021/10/21
 */
@Service
public class BaofengApi {

    private static final Logger logger = LoggerFactory.getLogger(BaofengApi.class);

    private static final String CHARACTER_ENCODE = "UTF-8";
    private static final String APPLICATION_JSON = "application/json";


    @Autowired
    private BaofengConfig baofengConfig;

    public boolean isBaofengAppid(Long appId) {
        String baofengAppId = baofengConfig.getAppId();
        return StringUtils.isNotBlank(baofengAppId) && baofengAppId.equals(String.valueOf(appId));
    }

    /**
     * 宝丰加积分请求
     *
     * @param request
     * @return
     */
    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request) {
        request.setHttpUrl(request.getHttpUrl());
        Map<String, String> authParams = request.getAuthParams();

        //获取（用户id）
        String uId = authParams.get("uid");
        // 获取积分数量
        String credits = authParams.get("credits");

        authParams.put("unionid", uId);
        authParams.put("score", credits);
        request.setAuthParams(authParams);
        request.setHttpType(CreditsMessage.HTTP_POST);
        return request;
    }

    /**
     * 构造加积分请求 remote
     *
     * @param
     * @return
     */
    public HttpRequestBase getAddCreditsHttpRequestBase(CreditsMessageDto message) {
        Map<String, String> params = message.getAuthParams();
        String paramsJsonStr = JSONObject.toJSONString(params);
        HttpPost httpPost = new HttpPost(message.getHttpUrl());
        StringEntity stringEntity = new StringEntity(paramsJsonStr, CHARACTER_ENCODE);
        httpPost.setEntity(stringEntity);
        httpPost.setHeader("Content-Type", "application/json; charset=UTF-8");
        logger.info("宝丰定制加积分请求，requestUrl：{}，params：{}", message.getHttpUrl(), paramsJsonStr);
        return httpPost;
    }

    /**
     * 响应加积分
     * @param body
     * @param authParams
     * @return
     */
    public String getResponseCredits(String body, Map<String, String> authParams) {
        JSONObject jsonBody;
        try {
            jsonBody = JSON.parseObject(body);
            Map<String, String> duibaDoc = new HashMap<>();
            Long code = Long.valueOf(jsonBody.getString("code"));
            if (200==code) {
                duibaDoc.put("status", "ok");
            } else {
                logger.warn("宝丰定制积分加减响应失败 body={}，请求参数={}", body, JSON.toJSONString(authParams));
                duibaDoc.put("status", "fail");
            }
            duibaDoc.put("bizId", authParams.get("requestNo"));
            //获取用户积分
            String data = JSON.toJSONString(jsonBody.get("data"));
            JSONObject parse = JSONObject.parseObject(data,JSONObject.class);
            duibaDoc.put("credits", parse.getString("score"));
            return JsonTool.objectToJson(duibaDoc);
        } catch (Exception e) {
            logger.error("宝丰定制积分加减响应异常 body={}", body, e);
            return body;
        }
    }

    public static void main(String[] args) {

        Map<String, String> map = new HashMap<>();
        map.put("unionid", "test");
        map.put("score", "100");

        HttpPost httpPost = new HttpPost("https://bfapi.shengway.com/index.php?r=v1/customer-score&token=111");
        StringEntity se = new StringEntity(JSON.toJSONString(map), CHARACTER_ENCODE);
        httpPost.setEntity(se);
        httpPost.setHeader("Content-Type", "application/json; charset=UTF-8");
        String result = null;
        try {
            CloseableHttpClient client = HttpClients.createDefault();
            HttpResponse response = client.execute(httpPost);
            HttpEntity respEntity = response.getEntity();
            if (respEntity != null) {
                result = EntityUtils.toString(respEntity, "utf-8");
            }
            EntityUtils.consume(respEntity);
            logger.info("宝丰加积分接口执行结果：{}",result);
        } catch (IOException e) {
            logger.error("返回结果：{}", e.getMessage());
            e.printStackTrace();
        }

    }


}
