package cn.com.duiba.biz.credits;

import cn.com.duiba.constant.DongguanBankConfig;
import cn.com.duiba.credits.sdk.CreditConsumeParams;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.dongguanbank.MD5Util;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 东莞银行 <br>
 *
 * @author: xuwei
 * @date: 2020/10/30
 */
@Service
public class DongguanBankApi {

    public static final Logger LOG = LoggerFactory.getLogger(DongguanBankApi.class);

    @Autowired
    private DongguanBankConfig dongguanBankConfig;

    public boolean isDongguanBank(Long appId) {
        return dongguanBankConfig.isDongguanBank(appId);
    }

    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        CreditConsumeParams creditConsumeParams = message.getSubCreditsMsg().getCreditConsumeParams();
        Map<String, Object> params = new HashMap<>();
        params.put("thirdCode", dongguanBankConfig.getThirdCode());
        String refrenceNo = compressOrderNum(creditConsumeParams.getOrderNum());
        params.put("refrenceNo", refrenceNo);
        params.put("score", creditConsumeParams.getCredits());
        params.put("clientId", creditConsumeParams.getUid());
        params.put("timestamp", creditConsumeParams.getTimestamp().getTime());
        params.put("sign", sign(dongguanBankConfig.getThirdCode(), refrenceNo, creditConsumeParams.getCredits(), creditConsumeParams.getUid(), creditConsumeParams.getTimestamp().getTime()));
        String newUrl = message.getHttpUrl().substring(0, message.getHttpUrl().indexOf('?'));
        HttpPost request = new HttpPost(newUrl);
        request.setEntity(new StringEntity(JSON.toJSONString(params), ContentType.APPLICATION_JSON));
        message.setHttpUrl(newUrl);
        LOG.info("[dongguanbank]东莞银行扣积分请求 orderNum={}, url={}, params={}", creditConsumeParams.getOrderNum(), message.getHttpUrl(), JSON.toJSONString(params));
        return request;
    }

    private String compressOrderNum(String orderNum) {
        int split = orderNum.indexOf('-');

        String orderId = split < 0 ? orderNum : orderNum.substring(split + 1);
        if (StringUtils.contains(orderId, 'C')) {
            orderId = StringUtils.replace(orderId, "C", "");
        }

        if (!StringUtils.isNumeric(orderId)) {
            return generateDefaultOrderNum();
        }

        StringBuilder sb = new StringBuilder(20);
        if (split > 0) {
            sb.append(orderNum, 0, split).append('-');
        }
        sb.append(new BigInteger(orderId).toString(36));

        return sb.length() > 20 ? generateDefaultOrderNum() : sb.toString();
    }

    private String generateDefaultOrderNum() {
        return "sys-" + BigInteger.valueOf(System.currentTimeMillis()).toString(36);
    }

    private String sign(Object... params) {
        try {
            return MD5Util.md5(StringUtils.join(params), dongguanBankConfig.getSaltKey());
        } catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public String parseCreditsResponse(String body) {
        LOG.info("[dongguanbank]东莞银行扣积分请求结果 {}", body);
        JSONObject json = JSON.parseObject(body);
        JSONObject result = new JSONObject();
        if (Objects.equals("S0000", json.getString("returnCode"))) {
            result.put("status", "ok");
            // 开发者不返回订单号，自定义
            result.put("bizId", System.currentTimeMillis() + RandomStringUtils.randomNumeric(6));
        } else {
            result.put("status", "fail");
            result.put("errorMessage", json.getString("returnMsg"));
        }
        return result.toJSONString();
    }

    public HttpRequestBase getSubCreditsHttpRequest(CreditsMessage message) {
        String url = message.getHttpUrl();
        String newUrl = url.substring(0, url.indexOf('?'));
        String paramsStr = url.substring(url.indexOf('?') + 1);
        Map<String, String> authParams = AssembleTool.getUrlParams(paramsStr);
        Map<String, Object> params = new HashMap<>();
        params.put("thirdCode", dongguanBankConfig.getThirdCode());
        String refrenceNo = compressOrderNum(authParams.get("orderNum"));
        params.put("refrenceNo", refrenceNo);
        params.put("score", authParams.get("credits"));
        params.put("clientId", authParams.get("uid"));
        params.put("timestamp", authParams.get("timestamp"));
        params.put("sign", sign(dongguanBankConfig.getThirdCode(), refrenceNo, authParams.get("credits"), authParams.get("uid"), authParams.get("timestamp")));
        HttpPost request = new HttpPost(newUrl);
        request.setEntity(new StringEntity(JSON.toJSONString(params), ContentType.APPLICATION_JSON));
        message.setHttpUrl(newUrl);
        LOG.info("[dongguanbank]东莞银行扣积分请求 orderNum={}, url={}, params={}", authParams.get("orderNum"), message.getHttpUrl(), JSON.toJSONString(params));
        return request;
    }
}
