package cn.com.duiba.biz.credits;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.constant.ShandongChinaMobileConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.tool.AssembleTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Map;

@Service
public class ShandongChinaMobileApi {
    private static final Logger log = LoggerFactory.getLogger(ShandongChinaMobileApi.class);

    private static final String CHANNEL_CODE = "duiba";
    private static final String SUCCESS_CODE = "0";

    @Resource
    private ShandongChinaMobileConfig shandongChinaMobileConfig;

    public boolean isShandongChinaMobile(Long appId) {
        return shandongChinaMobileConfig.getAppIds().contains(appId);
    }

    /**
     * rpc减积分
     */
    public CreditsMessage getSubCreditsMessage(CreditsMessage message) {
        String url = message.getHttpUrl();
        String newUrl = url.substring(0, url.indexOf('?'));
        Map<String, String> authParams = message.getAuthParams();

        message.setHttpUrl(AssembleTool.assembleUrl(newUrl, this.getNewParamMap(authParams)));

        return message;
    }

    /**
     * mq减积分
     */
    public SubCreditsMsgWrapper getSubCreditsMessage(SubCreditsMsgWrapper message) {
        String url = message.getHttpUrl();
        String newUrl = url.substring(0, url.indexOf('?'));
        Map<String, String> authParams = message.getSubCreditsMsg().getAuthParams();

        message.setHttpUrl(AssembleTool.assembleUrl(newUrl, this.getNewParamMap(authParams)));
        return message;
    }

    /**
     * 解析积分响应
     * @param body 积分响应
     * @return 积分响应
     */
    public String parseCreditsRsp(String body) {
        log.info("山东移动积分response, body={}", body);

        JSONObject jsonBody = JSON.parseObject(body);

        JSONObject response = new JSONObject();
        if (StringUtils.isNotEmpty(body) && SUCCESS_CODE.equals(jsonBody.getString("resultCode"))) {
            response.put("status", "ok");
            response.put("credits", jsonBody.getJSONObject("resultObject").getString("ownHoney"));
            response.put("bizId", jsonBody.getJSONObject("resultObject").getString("orderId"));
        } else {
            response.put("status", "fail");
            response.put("errorMessage", jsonBody.get("resultMessage"));
        }

        return response.toString();
    }

    private Map<String, String> getNewParamMap(Map<String, String> params) {
        Map<String, String> map = Maps.newHashMap();
        map.put("telnum", params.get("uid"));
        // 测试数据
        if (SpringEnvironmentUtils.isDevEnv() || SpringEnvironmentUtils.isTestEnv()) {
            map.put("telnum", "14706407549");
        }
        map.put("costHoney", params.get("credits"));
        map.put("goodsName", params.get("description"));
        map.put("orderId", params.get("orderNum"));
        map.put("channelCode", CHANNEL_CODE);
        map.put("sign", this.generateSign(map));

        return map;
    }

    /**
     * 生成签名
     */
    private String generateSign(Map<String, String> contentMap) {
        String plaintext = contentMap.get("orderId") + "_" + contentMap.get("channelCode");

        try {
            KeySpec keySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(shandongChinaMobileConfig.getPrivateKey()));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey key = keyFactory.generatePrivate(keySpec);

            Signature signature = Signature.getInstance("MD5withRSA");
            signature.initSign(key);
            signature.update(plaintext.getBytes());

            return Base64.getEncoder().encodeToString(signature.sign());
        } catch (Exception e) {
            log.error("山东移动签名生成失败, param={}", contentMap, e);
            throw new ThirdpatyException("山东移动签名生成失败");
        }
    }

}
