package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.config.ZhongYiConfig;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteConsumerOrderSimpleService;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.CreditSignUtil;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.vo.zhongyi.ZhongyiDescDetailVO;
import cn.com.duiba.vo.zhongyi.ZhongyiDescriptionVO;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;


/**
 * @author MeiChang
 * @Description
 */
@Component
public class ZhongYiApiStrategy implements ApiStrategy {

    private static final Logger log = LoggerFactory.getLogger(ZhongYiApiStrategy.class);

    @Resource
    private ZhongYiConfig zhongYiConfig;

    @Autowired
    private RemoteConsumerOrderSimpleService remoteConsumerOrderSimpleService;
    @Override
    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        try {
            log.info("掌上中意扣积分请求 :{}", JSON.toJSONString(message));
            String finalUrl = handleDescription(message.getHttpUrl(),message.getSubCreditsMsg().getAppSecret());
            log.info("掌上中意扣积分请求,最终url :{}", finalUrl);
            URIBuilder uriBuilder = new URIBuilder(finalUrl);

            HttpGet httpGet = new HttpGet(uriBuilder.build());
            //x-request-send-timestamp
            long timeMillis = System.currentTimeMillis() / 1000L;
            //x-signature
            String signature = CreditSignUtil.generateSignature(zhongYiConfig.getAccessId(),zhongYiConfig.getAccessKey(), timeMillis);
            httpGet.addHeader("x-access-id", zhongYiConfig.getAccessId());
            httpGet.addHeader("x-signature", signature);
            httpGet.addHeader("x-request-send-timestamp", String.valueOf(timeMillis));
            httpGet.addHeader("Content-Type", "application/x-www-form-urlencoded");
            log.info("掌上中意 AllHeaders: {}",JSON.toJSONString(httpGet.getAllHeaders()));
            return httpGet;
        }catch (Exception e){
            log.warn("掌上中意 getMqSubCreditsHttpRequest",e);
            throw new IllegalStateException(e);
        }
    }


    @Override
    public HttpRequestBase getAddCreditsMessageRequest(CreditsMessageDto message) {
        try{
            log.info("掌上中意加积分请求 :{}", JSON.toJSONString(message));
            String httpUrl = message.getHttpUrl();
            URIBuilder uriBuilder = new URIBuilder(httpUrl);
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            //x-request-send-timestamp
            long timeMillis = System.currentTimeMillis() / 1000L;
            //x-signature
            String signature = CreditSignUtil.generateSignature(zhongYiConfig.getAccessId(),zhongYiConfig.getAccessKey(), timeMillis);
            httpGet.addHeader("x-access-id", zhongYiConfig.getAccessId());
            httpGet.addHeader("x-signature", signature);
            httpGet.addHeader("x-request-send-timestamp", String.valueOf(timeMillis));
            httpGet.addHeader("Content-Type", "application/x-www-form-urlencoded");
            log.info("掌上中意 AllHeaders: {}",JSON.toJSONString(httpGet.getAllHeaders()));
            return httpGet;

        }catch (Exception e){
            log.warn("掌上中意 构建加积分请求失败",e);
            throw new IllegalStateException(e);
        }

    }

    @Override
    public HttpRequestBase getVirtualRequest(SupplierRequest request) {

        try{
            log.info("掌上中意虚拟商品充值请求 :{}", JSON.toJSONString(request));
            String httpUrl = request.getHttpUrl();
            URIBuilder uriBuilder = new URIBuilder(httpUrl);
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            //x-request-send-timestamp
            long timeMillis = System.currentTimeMillis() / 1000L;
            //x-signature
            String signature = CreditSignUtil.generateSignature(zhongYiConfig.getAccessId(),zhongYiConfig.getAccessKey(), timeMillis);
            httpGet.addHeader("x-access-id", zhongYiConfig.getAccessId());
            httpGet.addHeader("x-signature", signature);
            httpGet.addHeader("x-request-send-timestamp", String.valueOf(timeMillis));
            httpGet.addHeader("Content-Type", "application/x-www-form-urlencoded");
            log.info("掌上中意 AllHeaders: {}",JSON.toJSONString(httpGet.getAllHeaders()));
            return httpGet;

        }catch (Exception e){
            log.warn("掌上中意 构建虚拟商品充值请求",e);
            throw new IllegalStateException(e);
        }
    }

    /**
     * 处理描述字段
     * @param url
     * @return
     */
    private String handleDescription(String url, String appSecret){
        log.info("【中意】，appsecret:{}",appSecret);
        Map<String, String> urlParams = AssembleTool.getUrlParams(url.substring(url.indexOf("?") + 1));
        String uid = urlParams.get("uid");
        String description = urlParams.get("description");
        Long credits = Long.valueOf(urlParams.get("credits"));
        String orderNum = urlParams.get("orderNum");
        ZhongyiDescDetailVO zhongyiDescDetailVO = new ZhongyiDescDetailVO();
        zhongyiDescDetailVO.setName(description);

        DubboResult<OrdersDto> ordersDtoResult =
                remoteConsumerOrderSimpleService.findByOrderNum(orderNum);
        OrdersDto ordersDto = null;
        if(ordersDtoResult.isSuccess() && Objects.nonNull(ordersDto = ordersDtoResult.getResult())){
            zhongyiDescDetailVO.setName(ordersDto.getBrief());
        }
        zhongyiDescDetailVO.setAmount(1L);
        zhongyiDescDetailVO.setPrice(credits);
        zhongyiDescDetailVO.setOriginPrice(credits);


        ZhongyiDescriptionVO zhongyiDescriptionVO = new ZhongyiDescriptionVO();
        zhongyiDescriptionVO.setCount(credits);
        zhongyiDescriptionVO.setUserId(uid);
        zhongyiDescriptionVO.setSn(orderNum);
        zhongyiDescriptionVO.setDetail(Lists.newArrayList(zhongyiDescDetailVO));


        urlParams.put("description",JSON.toJSONString(zhongyiDescriptionVO));
        urlParams.put("appSecret",appSecret);
        //重新签名
        urlParams.remove("sign");
        log.info("【中意】，需要签名的参数列表:{}",urlParams.toString());
        String sign = SignTool.sign(urlParams);
        urlParams.remove("appSecret");
        urlParams.put("sign",sign);
        log.info("处理完之后的url参数:{}",urlParams.toString());
        String finalUrl = AssembleTool.assembleUrl(url.substring(0, url.indexOf("?")), urlParams);
        return finalUrl;
    }

    @Override
    public String parseCreditsRsp(String body,Boolean addCredits, Map<String, String> authParams){
        //body {
        //        "credits":653,
        //        "errorMessage":"",
        //        "status":"success",
        //        "supplierBizId":"plugin-1814464583502600924"
        //}
        Map<String, String> duibaDoc = new HashMap<>();
        JSONObject  ret = null;
        try {
            ret = JSONObject.parseObject(body);
        } catch (Exception e) {
            log.warn("【中意】，parseCreditsRsp body 解析失败:{}",body);
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage","json解析失败");
            return JsonTool.objectToJson(duibaDoc);
        }
        if(ret!=null && ("success".equalsIgnoreCase(ret.getString("status")) || "ok".equalsIgnoreCase(ret.getString("status")))){
            duibaDoc.put("status", "ok");
            duibaDoc.put("bizId", ret.getString("bizId"));
            duibaDoc.put("credits", ret.getString("credits"));
        } else {
            duibaDoc.put("status", "fail");
            duibaDoc.put("bizId", ret.getString("bizId"));
            duibaDoc.put("errorMessage",ret.getString("errorMessage"));
        }
        return JsonTool.objectToJson(duibaDoc);
    }

    public static void main(String[] args) {
        String url = "www.baidu.com?uid=1&description=aaaaa";

        System.out.println(url.substring(url.indexOf("?") + 1));
        System.out.println(url.substring(0,url.indexOf("?")));
    }
}
