package cn.com.duiba.biz.credits.unionpay;

import cn.com.duiba.domain.SupplierRequest;
import org.apache.http.client.methods.HttpRequestBase;

import java.util.Set;

public interface UnionPayRequest {
    /**
     * 虚拟商品子类型
     *
     * @return 返回兑吧虚拟商品子类型
     */
    Set<Long> getAppIdSet();

    /**
     * 具体提交虚拟商品请求
     * @param request 虚拟商品请求
     * @param merchantCoding 虚拟商品编码
     */
    HttpRequestBase getVirtualRequest(SupplierRequest request, String merchantCoding);

    /**
     * 解析虚拟商品返回结果
     * @param request
     * @param body
     * @return
     */
    String getVirtualResponse(SupplierRequest request, String body, String merchantCoding);
}
