package cn.com.duiba.constant;

import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.biz.credits.strategy.Impl.JingDongApiStrategy;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author haojiahong
 * @date 2020-06-23
 */
@Configuration
@ConfigurationProperties(prefix = "jingdong")
public class JingDongConfig implements InitializingBean {

    private static final Logger LOGGER = LoggerFactory.getLogger(JingDongConfig.class);

    @Autowired
    private JingDongApiStrategy jingDongApiStrategy;

    private String configStr = "[{\"appId\":19543,\"shopId\":10139787,\"venderId\":10276497},{\"appId\":84507,\"shopId\":1000001469,\"venderId\":1000001469}]";

    private String url = "https://duiba-isv.isvjcloud.com";

    private Map<Long, JingDongConfigBean> configMap;


    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getConfigStr() {
        return configStr;
    }

    public void setConfigStr(String configStr) {
        this.configStr = configStr;
    }

    public Map<Long, JingDongConfigBean> getConfigMap() {
        return configMap;
    }

    public void setConfigMap(Map<Long, JingDongConfigBean> configMap) {
        this.configMap = configMap;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        try {
            if (StringUtils.isNotBlank(configStr)) {
                configMap = JSON.parseArray(configStr, JingDongConfigBean.class).stream()
                        .collect(Collectors.toMap(JingDongConfigBean::getAppId, Function.identity(), (a, b) -> a));
            }
            LOGGER.info("京东定制，配置初始化成功，configStr={}", configStr);
        } catch (Exception e) {
            LOGGER.warn("京东定制，配置初始化失败，configStr={}", configStr);

        }

        LOGGER.info("京东开始注册策略---------");
        ApiStrategyRouter.register(configMap.keySet(), jingDongApiStrategy);
    }


    public enum Api {
        /**
         * 消耗店铺积分
         */
        CONSUMER_POINTS("/open2Duiba/consumePoints"),

        /**
         * 获取用户积分值
         */
        GET_CUSTOMER_POINTS("/open2Duiba/getCustomerPoints"),

        ;

        String path;

        Api(String path) {
            this.path = path;
        }

        public String getPath() {
            return path;
        }

        public String getApiAbsolutePath(JingDongConfig config) {
            return config.getUrl() + this.getPath();
        }

    }


    public static class JingDongConfigBean {
        private Long appId;
        /**
         * 京东商家id
         */
        private Long venderId;
        /**
         * 京东店铺id
         */
        private Long shopId;


        public Long getAppId() {
            return appId;
        }

        public void setAppId(Long appId) {
            this.appId = appId;
        }

        public Long getVenderId() {
            return venderId;
        }

        public void setVenderId(Long venderId) {
            this.venderId = venderId;
        }

        public Long getShopId() {
            return shopId;
        }

        public void setShopId(Long shopId) {
            this.shopId = shopId;
        }

        public static void main(String[] args) {
            List<JingDongConfigBean> beanList = Lists.newArrayList();

            JingDongConfigBean bean1 = new JingDongConfigBean();
            bean1.setAppId(19543L);
            bean1.setVenderId(10276497L);
            bean1.setShopId(10139787L);

            beanList.add(bean1);

            JingDongConfigBean bean2 = new JingDongConfigBean();
            bean2.setAppId(84507L);
            bean2.setVenderId(1000001469L);
            bean2.setShopId(1000001469L);

            beanList.add(bean2);
            System.out.println(JSON.toJSONString(beanList));
        }
    }


}
