package cn.com.duiba.constant;

import com.google.common.collect.Sets;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Set;

/**
 * @author fja
 */
@Configuration
@ConfigurationProperties("inoherb.new")
public class NewInoherbConfig {
    /**
     * appid集合
     */
    private Set<Long> appIds = Sets.newHashSet();
    /**
     * 对接的appId
     */
    private String developerAppId = "duiba";
    /**
     * 对接的appsecret
     */
    private String developSecret = "duiba";

    /**
     * processType 映射
     */
    private String processTypes;

    /**
     * issueType 映射
     */
    private String issueTypes;
    /**
     * 虚拟商品加积分开发者请求路径
     */
    private String virtualProductAddCreditsUrl = "http://admin-xybc-trunk.oudianyun.com/inoherb-web/openApi/integralChange.do";
    /**
     * 商品号分割字符串后积分的索引号
     */
    private int virtualCreditsIndex = 1;

    /**
     * 开关
     */
    private boolean newLogic = true;

    public String getDeveloperAppId() {
        return developerAppId;
    }

    public void setDeveloperAppId(String developerAppId) {
        this.developerAppId = developerAppId;
    }

    public String getDevelopSecret() {
        return developSecret;
    }

    public void setDevelopSecret(String developSecret) {
        this.developSecret = developSecret;
    }

    public String getProcessTypes() {
        return processTypes;
    }

    public void setProcessTypes(String processTypes) {
        this.processTypes = processTypes;
    }

    public String getIssueTypes() {
        return issueTypes;
    }

    public void setIssueTypes(String issueTypes) {
        this.issueTypes = issueTypes;
    }

    public Set<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }

    public String getVirtualProductAddCreditsUrl() {
        return virtualProductAddCreditsUrl;
    }

    public void setVirtualProductAddCreditsUrl(String virtualProductAddCreditsUrl) {
        this.virtualProductAddCreditsUrl = virtualProductAddCreditsUrl;
    }

    public int getVirtualCreditsIndex() {
        return virtualCreditsIndex;
    }

    public void setVirtualCreditsIndex(int virtualCreditsIndex) {
        this.virtualCreditsIndex = virtualCreditsIndex;
    }

    public boolean isNewLogic() {
        return newLogic;
    }

    public void setNewLogic(boolean newLogic) {
        this.newLogic = newLogic;
    }
}
