package cn.com.duiba.constant;

import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.biz.credits.strategy.Impl.PingAnLifeInsuranceStrategy;
import com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Set;

/**
 * @ClassName PingAnLifeInsuranceConfig
 * @Description
 * @Author liheping
 * @Date 2021/7/26
 **/

@Configuration
@ConfigurationProperties(prefix = "pingan.life.insurance")
public class PingAnLifeInsuranceConfig implements InitializingBean {

    private static final Logger log = LoggerFactory.getLogger(PingAnLifeInsuranceConfig.class);


    @Autowired
    private PingAnLifeInsuranceStrategy pingAnLifeInsuranceStrategy;

    /**
     * 参加活动appid列表
     */
    private Set<Long> appIds = Sets.newHashSet(83523L, 84082L);

    public Set<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        log.info("开始注册策略---------");
        ApiStrategyRouter.register(appIds, pingAnLifeInsuranceStrategy);
    }
}
