package cn.com.duiba.constant;

import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.biz.credits.strategy.Impl.ZhilianApiStrategy;
import com.google.common.collect.Sets;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Set;

@Configuration
@ConfigurationProperties(prefix = "zhilian")
public class ZhiLianConfig implements InitializingBean {
    /**
     * 应用id集合
     */
    private Set<Long> appIdSet = Sets.newHashSet(86002L);

    @Autowired
    private ZhilianApiStrategy zhiLianApiStrategy;

    public Set<Long> getAppIdSet() {
        return appIdSet;
    }

    public void setAppIdSet(Set<Long> appIdSet) {
        this.appIdSet = appIdSet;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        ApiStrategyRouter.register(getAppIdSet(), zhiLianApiStrategy);
    }
}
