package cn.com.duiba.remoteimpl.hsbc;

import cn.com.duiba.biz.credits.strategy.Impl.HsbcApiStrategy;
import cn.com.duiba.thirdparty.api.hsbc.RemoteHsbcBankServcie;
import cn.com.duiba.thirdparty.dto.hsbc.UserInfoDto;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author haojiahong
 * @date 2021-12-27
 */
@RestController
public class RemoteHsbcBankServcieImpl implements RemoteHsbcBankServcie {

    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteHsbcBankServcieImpl.class);

    @Autowired
    private HsbcApiStrategy hsbcApiStrategy;

    @Override
    public UserInfoDto getUserInfo(String hsbcOpenId, String hsbcAppId) {
        if (StringUtils.isBlank(hsbcOpenId) || StringUtils.isBlank(hsbcAppId)) {
            LOGGER.warn("获取汇丰用户信息，参数有误，hsbcOpenId={} hsbcAppId={}", hsbcOpenId, hsbcAppId);
            return null;
        }
        UserInfoDto userInfoDto = hsbcApiStrategy.getUserInfo(hsbcOpenId, hsbcAppId);
        return userInfoDto;
    }

}
