package cn.com.duiba.remoteimpl.wufangzhai;

import cn.com.duiba.biz.credits.WuFangZhaiApi;
import cn.com.duiba.dto.wufangzhai.WfzTokenBean;
import cn.com.duiba.thirdparty.api.wufangzhai.RemoteWuFangZhaiService;
import cn.com.duiba.thirdparty.dto.wufangzhai.WfzTokenDto;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author haojiahong
 * @date 2020-06-30
 */
@RestController
public class RemoteWuFangZhaiServiceImpl implements RemoteWuFangZhaiService {

    @Autowired
    private WuFangZhaiApi wuFangZhaiApi;

    @Override
    public WfzTokenDto getToken() {
        WfzTokenBean wfzTokenBean = wuFangZhaiApi.getToken(null);
        if (wfzTokenBean == null) {
            return null;
        }
        WfzTokenDto wfzTokenDto = BeanUtils.copy(wfzTokenBean, WfzTokenDto.class);
        return wfzTokenDto;
    }

    @Override
    public WfzTokenDto getTokenV1(Long appId) {
        WfzTokenBean wfzTokenBean = wuFangZhaiApi.getToken(appId.toString());
        if (wfzTokenBean == null) {
            return null;
        }
        WfzTokenDto wfzTokenDto = BeanUtils.copy(wfzTokenBean, WfzTokenDto.class);
        return wfzTokenDto;
    }
}
