package cn.com.duiba.remoteimpl.yangshipin;

import cn.com.duiba.constant.YangShiPinConfig;
import cn.com.duiba.thirdparty.api.yangshipin.RemoteYangShiPinService;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.MD5;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author chenzhenxing
 * @date 2022/1/11 10:21 上午
 */
@RestController
public class RemoteYangShiPinServiceImpl implements RemoteYangShiPinService {
    private static final Logger log = LoggerFactory.getLogger(RemoteYangShiPinServiceImpl.class);

    private static final RequestConfig requestConfig;

    private static final int FIVE_SECONDS = 5*1000;

    private static final int TEN_SECONDS = 10*1000;

    static {
        //http请求超时配置
        requestConfig = RequestConfig.custom().setConnectTimeout(FIVE_SECONDS).setSocketTimeout(TEN_SECONDS).setConnectionRequestTimeout(500).build();
    }

    @Resource(name = "httpClient")
    private CloseableHttpClient httpClient;

    @Resource
    private YangShiPinConfig yangShiPinConfig;

    @Override
    public Boolean checkIsIceCardUser(String phone) {
        boolean result = false;
        try {
            Map<String, String> urlParams = new HashMap<>();
            urlParams.put("appId",yangShiPinConfig.getCustomerSupplyAppId());
            urlParams.put("timestamp",String.valueOf(System.currentTimeMillis()));
            urlParams.put("randStr",yangShiPinConfig.getRandStr());
            urlParams.put("phone", MD5.md5(phone));
            //计算sign
            urlParams.put("appSecret",yangShiPinConfig.getCustomerSupplyAppSecret());
            List<String> list = new ArrayList<>(urlParams.keySet());
            List<String> keys = list.stream().sorted(Comparator.comparing(Function.identity())).collect(Collectors.toList());
            StringBuilder signResource = new StringBuilder();
            for(String key:keys){
                String value = urlParams.get(key);
                signResource.append(value);
            }
            String sign = MD5.md5(signResource.toString());
            urlParams.put("sign",sign);
            urlParams.remove("appSecret");
            urlParams.put("vappid",yangShiPinConfig.getvAppId());
            urlParams.put("vsecret",yangShiPinConfig.getvSecret());
            urlParams.put("raw",yangShiPinConfig.getRaw());
            String assembleUrl = AssembleTool.assembleUrl(yangShiPinConfig.getIsIceCardUrl(), urlParams);
            log.info("央视频判断用户是否冰雪卡用户请求url={}",assembleUrl);
            HttpGet httpGet = new HttpGet(assembleUrl);
            httpGet.setConfig(requestConfig);
            String s = yangShiPinRequest(httpGet);
            JSONObject jsonObject = JSONObject.parseObject(s);
            if (jsonObject.containsKey("ret") && 0 == jsonObject.getInteger("ret")){
                JSONObject data = jsonObject.getJSONObject("data");
                if (data != null){
                    result = data.getBoolean("isIceCard");
                }
            }
        } catch (Exception e) {
            log.warn("央视频判断用户是否冰雪卡用户异常,phone={}",phone,e);
        }
        return result;
    }

    private String yangShiPinRequest(HttpUriRequest httpRequest) {
        try(final CloseableHttpResponse response = httpClient.execute(httpRequest)) {
            // 响应参数
            String responseStr = EntityUtils.toString(response.getEntity());
            log.info("央视频判断用户是否冰雪卡用户响应参数，param:{}", responseStr);
            return responseStr;
        } catch (Exception e) {
            log.warn("央视频判断用户是否冰雪卡用户响应异常，url:{},param:{}",httpRequest.getURI().getPath(), JSON.toJSONString(httpRequest), e);
        }
        return "";
    }
}
