package cn.com.duiba.remoteimpl.zhiji;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.constant.zhiji.ZhiJiConfig;
import cn.com.duiba.enums.zhiji.ZhiJiCodeEnum;
import cn.com.duiba.enums.zhiji.ZhiJiStatusEnum;
import cn.com.duiba.thirdparty.api.zhiji.RemoteZhiJiService;
import cn.com.duiba.thirdparty.dto.zhiji.request.ZhiJiBlindBoxRequest;
import cn.com.duiba.thirdparty.dto.zhiji.request.ZhiJiGoodsRequest;
import cn.com.duiba.thirdparty.dto.zhiji.request.ZhiJiOrderInfoDto;
import cn.com.duiba.thirdparty.dto.zhiji.request.ZhiJiSignProtocolRequest;
import cn.com.duiba.thirdparty.dto.zhiji.response.ZhiJiBlindBoxResponse;
import cn.com.duiba.thirdparty.dto.zhiji.response.ZhiJiOrderResponse;
import cn.com.duiba.thirdparty.dto.zhiji.response.ZhiJiProtocolResponse;
import cn.com.duiba.thirdparty.dto.zhiji.response.ZhiJiResponse;
import cn.com.duiba.thirdparty.dto.zhiji.ZhiJiUserReceivedAddressDto;
import cn.com.duiba.tool.zhiji.ZhiJiParamTool;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.*;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @author: pengyi
 * @description: 智己汽车-对外接口实现
 * @date: 2021/9/1 下午1:52
 */
@RestController
public class RemoteZhiJiServiceImpl implements RemoteZhiJiService {

    private static final Logger log = LoggerFactory.getLogger(RemoteZhiJiServiceImpl.class);

    @CanAccessInsideNetwork
    @Resource(name = "httpClient")
    private CloseableHttpClient httpClient;
    @Autowired
    private ZhiJiConfig zhiJiConfig;
    @CanAccessInsideNetwork
    @Resource(name = "stringRedisTemplate")
    private StringRedisTemplate redisTemplate;
    @Autowired
    private ZhiJiParamTool zhiJiParamTool;

    private static final String SOURCE = "DUIBA";

    @Override
    public String saveReceiveAddress(ZhiJiUserReceivedAddressDto dto) {
        HttpPost httpPost = zhiJiParamTool.createHttpPost(dto, zhiJiConfig.getSaveAddressUrl(),zhiJiConfig.getDomainName());
        if (httpPost == null) {
            log.warn("智己-新增收获地址信息，请求失败，param:{}", JSON.toJSONString(dto));
            return ZhiJiStatusEnum.FAIL.getCode();
        }
        httpPost.setHeader("x-transaction-id",System.currentTimeMillis() + zhiJiParamTool.generateRandom());
        // 智己
        String responseStr = zhiJiRequest(httpPost);
        if (StringUtils.isBlank(responseStr)) {
            log.warn("智己-新增收获地址信息，智己响应失败，param:{}", responseStr);
            return ZhiJiStatusEnum.FAIL.getCode();
        }
        ZhiJiResponse respParam = JSONObject.parseObject(responseStr, ZhiJiResponse.class);
        // 智己侧响应失败
        if (!ZhiJiCodeEnum.SUCCESS_1.getCode().equals(respParam.getCode())) {
            log.warn("智己-新增收获地址信息，智己响应失败，param:{}", responseStr);
            return ZhiJiStatusEnum.FAIL.getCode();
        }
        // 响应成功，返回地址id
        return respParam.getTransactionId();
    }

    @Override
    public Boolean removeReceiveAddress(ZhiJiUserReceivedAddressDto dto) {
        HttpPost httpPost = zhiJiParamTool.createHttpPost(dto,zhiJiConfig.getRemoveAddressUrl(),zhiJiConfig.getDomainName());
        if (httpPost == null) {
            log.warn("智己-删除收获地址信息，请求失败，param:{}", JSON.toJSONString(dto));
            return false;
        }
        httpPost.setHeader("x-transaction-id",System.currentTimeMillis() + zhiJiParamTool.generateRandom());
        // 智己请求
        String responseStr = zhiJiRequest(httpPost);
        if (StringUtils.isBlank(responseStr)) {
            log.warn("智己-删除收获地址信息，智己响应失败，param:{}", responseStr);
            return false;
        }
        ZhiJiResponse zhiJiResponse = JSONObject.parseObject(responseStr, ZhiJiResponse.class);
        // 智己侧响应失败
        if (!ZhiJiCodeEnum.SUCCESS_1.getCode().equals(zhiJiResponse.getCode())) {
            log.warn("智己-删除收获地址信息，智己响应失败，param:{}", responseStr);
            return false;
        }
        // 响应成功
        return true;
    }

    @Override
    public Boolean updateReceiveAddress(ZhiJiUserReceivedAddressDto dto) {
        HttpPost httpPost = zhiJiParamTool.createHttpPost(dto,zhiJiConfig.getUpdateAddressUrl(),zhiJiConfig.getDomainName());
        if (httpPost == null) {
            log.warn("智己-编辑收获地址信息，请求失败，param:{}", JSON.toJSONString(dto));
            return false;
        }
        httpPost.setHeader("x-transaction-id",System.currentTimeMillis() + zhiJiParamTool.generateRandom());
        // 智己请求
        String responseStr = zhiJiRequest(httpPost);
        if (StringUtils.isBlank(responseStr)) {
            log.warn("智己-编辑收货地址信息，智己响应失败，param:{}", responseStr);
            return false;
        }
        ZhiJiResponse zhiJiResponse = JSONObject.parseObject(responseStr, ZhiJiResponse.class);
        // 智己侧响应失败
        if (!ZhiJiCodeEnum.SUCCESS_1.getCode().equals(zhiJiResponse.getCode())) {
            log.warn("智己-编辑收货地址信息，智己响应失败，param:{}", responseStr);
            return false;
        }
        // 响应成功
        return true;
    }

    @Override
    public List<ZhiJiUserReceivedAddressDto> selectReceiveAddress(String uid) {
        Map<String, String> params = new HashMap<>();
        params.put("uid", uid);
        params.put("source", "2");
        HttpGet httpGet = zhiJiParamTool.createHttpGet(params,zhiJiConfig.getSelectUserAddressUrl(),zhiJiConfig.getDomainName());
        if (httpGet == null) {
            log.warn("智己-查询收获地址信息，请求失败，param:{}", JSON.toJSONString(uid));
            return Collections.emptyList();
        }
        httpGet.setHeader("x-transaction-id",System.currentTimeMillis() + zhiJiParamTool.generateRandom());
        // 智己请求
        String responseStr = zhiJiRequest(httpGet);
        if (StringUtils.isBlank(responseStr)) {
            log.warn("智己-查询收货地址信息，智己响应失败，param:{}", responseStr);
            return null;
        }
        ZhiJiResponse zhiJiResponse = JSONObject.parseObject(responseStr, ZhiJiResponse.class);
        // 智己侧响应失败
        if (!ZhiJiCodeEnum.SUCCESS_1.getCode().equals(zhiJiResponse.getCode())) {
            log.warn("智己-查询收货地址信息，智己响应失败，param:{}", responseStr);
            return Collections.emptyList();
        }
        // 地址在data的blocks中
        JSONObject addressData = JSON.parseObject(JSON.toJSONString(zhiJiResponse.getData()));
        List<ZhiJiUserReceivedAddressDto> dtoList = JSONObject.parseArray(addressData.getString("blocks"), ZhiJiUserReceivedAddressDto.class);
        // 响应成功
        return dtoList;

    }

    @Override
    public ZhiJiOrderResponse syncOrderInfo(ZhiJiOrderInfoDto orderInfoDto) {
        // 构造订单同步信息
        Map<String,Object> body = new HashMap<>(1);
        body.put("body", orderInfoDto);
        HttpPost httpPost = zhiJiParamTool.createHttpPost(body, zhiJiConfig.getSyncOrderUrl(),zhiJiConfig.getDomainName());
        if (httpPost == null) {
            log.warn("智己-同步订单信息，请求失败，param:{}", JSON.toJSONString(orderInfoDto));
            return null;
        }
        // 智己请求
        String responseStr = zhiJiRequest(httpPost);
        if (StringUtils.isBlank(responseStr)) {
            log.warn("智己-同步订单信息，智己响应失败，param:{}", responseStr);
            return null;
        }
        ZhiJiOrderResponse zhiJiResponse = JSONObject.parseObject(responseStr, ZhiJiOrderResponse.class);
        // 智己侧响应失败
        if (ZhiJiStatusEnum.FAIL.getCode().equals(zhiJiResponse.getStatus()) || !ZhiJiCodeEnum.SUCCESS.getCode().equals(zhiJiResponse.getCode())) {
            log.warn("智己-同步订单信息，智己响应失败，param:{}", responseStr);
            return zhiJiResponse;
        }
        // 响应成功
        return zhiJiResponse;
    }

    @Override
    public ZhiJiOrderResponse syncOrderStatus(String orderNum, String status) {
        // 构造订单同步信息
        Map<String, Object> params = new HashMap<>();
        params.put("sourceCode", SOURCE);
        params.put("traceId", orderNum + RandomUtils.nextInt(100000, 999999));
        params.put("timestamp", System.currentTimeMillis());
        params.put("orderStatus", status);
        params.put("orderNum", orderNum);
        Map<String, Object> body = new HashMap<>();
        body.put("body", params);
        log.info("智己-同步订单状态信息，发送参数，param:{}", JSONObject.toJSONString(params));
        HttpPost httpPost = zhiJiParamTool.createHttpPost(body, zhiJiConfig.getSyncOrderStatusUrl(),zhiJiConfig.getDomainName());
        if (httpPost == null) {
            log.warn("智己-同步订单状态信息，请求失败，orderNum:{}, status:{}", orderNum, status);
            return null;
        }
        // 智己请求
        String responseStr = zhiJiRequest(httpPost);
        if (StringUtils.isBlank(responseStr)) {
            log.warn("智己-同步订单状态信息，智己响应失败，param:{}", responseStr);
            return null;
        }
        ZhiJiOrderResponse zhiJiResponse = JSONObject.parseObject(responseStr, ZhiJiOrderResponse.class);
        // 智己侧响应失败
        if (ZhiJiStatusEnum.FAIL.getCode().equals(zhiJiResponse.getStatus()) || !ZhiJiCodeEnum.SUCCESS.getCode().equals(zhiJiResponse.getCode())) {
            log.warn("智己-同步订单状态信息，智己响应失败，param:{}", responseStr);
            return null;
        }
        // 响应成功
        return zhiJiResponse;
    }

    @Override
    public JSONObject getUserCredits(String superId) {
        Map<String, Object> params = new HashMap<>();
        params.put("superId", superId);
        params.put("sourceCode", SOURCE);
        params.put("traceId", System.currentTimeMillis() + StringUtils.EMPTY + RandomUtils.nextInt(100000, 999999));
        Map<String, Object> body = new HashMap<>();
        body.put("body", params);
        HttpPost httpPost = zhiJiParamTool.createHttpPost(body,zhiJiConfig.getUserCreditsUrl(),zhiJiConfig.getDomainName());
        if (httpPost == null) {
            log.warn("智己-查询用户积分，请求失败，param:{}", JSON.toJSONString(superId));
            return null;
        }
        // 智己请求
        String responseStr = zhiJiRequest(httpPost);
        if (StringUtils.isBlank(responseStr)) {
            log.warn("智己-查询用户积分，智己响应失败，param:{}", responseStr);
            return null;
        }
        ZhiJiResponse zhiJiResponse = JSONObject.parseObject(responseStr, ZhiJiResponse.class);
        // 智己侧响应失败
        if (!ZhiJiCodeEnum.SUCCESS_2.getCode().equals(zhiJiResponse.getCode())) {
            log.warn("智己-查询用户积分，智己响应失败，param:{}", responseStr);
            return null;
        }
        // 响应成功
        return JSON.parseObject(JSON.toJSONString(zhiJiResponse));
    }

    @Override
    public JSONObject queryUserInfo(String token) {
        Map<String, String> params = new HashMap<>();
        HttpGet httpGet = zhiJiParamTool.createHttpGet(params,zhiJiConfig.getQueryUserInfoUrl(),zhiJiConfig.getDomainName());
        if (httpGet == null) {
            log.warn("智己-查询用户id信息，请求失败，param:{}", JSON.toJSONString(token));
            return null;
        }
        httpGet.setHeader("Authorization", "Bearer " + token);
        httpGet.setHeader("x-transaction-id",System.currentTimeMillis() + "@" + zhiJiParamTool.generateRandom() + "_duiba");
        log.info("智己-查询用户请求参数，header:{}", JSON.toJSONString(httpGet.getAllHeaders()));
        // 智己请求
        String responseStr = zhiJiRequest(httpGet);
        if (StringUtils.isBlank(responseStr)) {
            log.warn("智己-查询用户id信息，智己响应失败，param:{}", responseStr);
            return null;
        }
        ZhiJiResponse zhiJiResponse = JSONObject.parseObject(responseStr, ZhiJiResponse.class);
        // 智己侧响应失败
        if (!ZhiJiCodeEnum.SUCCESS_2.getCode().equals(zhiJiResponse.getResultCode())) {
            log.warn("智己-查询用户id信息，智己响应失败，param:{}", responseStr);
            return null;
        }
        // 响应成功
        return JSONObject.parseObject(zhiJiResponse.getData().toString());
    }

    @Override
    public boolean syncGoods(List<ZhiJiGoodsRequest> zhiJiGoodsRequestList) {
        Map<String, Object> map = new HashMap<>();
        map.put("timestamp", System.currentTimeMillis());
        map.put("sourceCode", SOURCE);
        map.put("traceId", System.currentTimeMillis() + org.apache.commons.lang3.StringUtils.EMPTY + zhiJiParamTool.generateRandom());
        Map<String, Object> shoppingMap = new HashMap<>();
        shoppingMap.put("shoppingProduct",zhiJiGoodsRequestList);
        map.put("ListOfIMShoppingProductIO", shoppingMap);
        Map<String, Object> body = new HashMap<>();
        body.put("body", map);
        HttpPost httpPost = zhiJiParamTool.createHttpPost(body,zhiJiConfig.getSyncGoodsUrl(),zhiJiConfig.getDomainName());
        if (httpPost == null) {
            log.warn("智己-新增收获地址信息，请求失败，param:{}", JSON.toJSONString(zhiJiGoodsRequestList));
            return false;
        }
        // 智己请求
        String responseStr = zhiJiRequest(httpPost);
        if (StringUtils.isBlank(responseStr)) {
            log.warn("智己-同步商品信息，智己响应失败，param:{}", responseStr);
            return false;
        }
        ZhiJiResponse zhiJiResponse = JSONObject.parseObject(responseStr, ZhiJiResponse.class);
        // 智己侧响应失败
        if (ZhiJiStatusEnum.FAIL.getCode().equals(zhiJiResponse.getStatus()) || !ZhiJiCodeEnum.SUCCESS.getCode().equals(zhiJiResponse.getCode())) {
            log.warn("智己-同步商品信息，智己响应失败，param:{}", responseStr);
            return false;
        }
        // 响应成功
        return Objects.equals(zhiJiResponse.getCode(), "0");
    }

    @Override
    public JSONArray queryDistrictList(String keywords, Integer subDistrict,String filter) {
        // 加缓存，创建订单的时候判断直辖市
        String key = "DISTRICT_" + keywords + "_" + subDistrict + "_" + filter;
        if (redisTemplate.hasKey(key) && StringUtils.isNotBlank(redisTemplate.opsForValue().get(key))) {
            return JSON.parseArray(redisTemplate.opsForValue().get(key));
        } else {
            Map<String, String> params = new HashMap<>(2);
            params.put("keywords", keywords);
            params.put("subDistrict", String.valueOf(subDistrict));
            params.put("filter", filter);
            HttpGet httpGet = zhiJiParamTool.createHttpGet(params, zhiJiConfig.getSelectDistrictUrl(),zhiJiConfig.getDomainName());
            if (httpGet == null) {
                log.warn("智己-省市区，请求失败，keywords:{},subDistrict:{}", keywords, subDistrict);
                return null;
            }
            // 智己请求
            String responseStr = zhiJiRequest(httpGet);
            if (StringUtils.isBlank(responseStr)) {
                log.warn("智己-省市区查询，智己响应失败，param:{}", responseStr);
                return null;
            }
            ZhiJiResponse zhiJiResponse = JSONObject.parseObject(responseStr, ZhiJiResponse.class);
            // 智己侧响应失败
            if (!ZhiJiCodeEnum.SUCCESS_1.getCode().equals(zhiJiResponse.getCode())) {
                log.warn("智己-省市区查询，智己响应失败，param:{}", responseStr);
                return null;
            }
            JSONObject address = JSON.parseObject(JSON.toJSONString(zhiJiResponse.getData()));
            // 响应成功，放入缓存中,1天有效
            redisTemplate.opsForValue().set(key, JSON.toJSONString(address.getJSONArray("blocks")), 1, TimeUnit.DAYS);
            return address.getJSONArray("blocks");
        }
    }

    @Override
    public Boolean blindBoxVerify(String uid, String blindBoxId, String goodsId) {
        Map<String, Object> params = new HashMap<>(3);
        params.put("userId", uid);
        params.put("blindBoxId", blindBoxId);
        params.put("goodsId", goodsId);
        HttpPost httpPost = zhiJiParamTool.createHttpPost(params,zhiJiConfig.getBlindBoxVerifyUrl(),zhiJiConfig.getDomainName());
        if (httpPost == null) {
            log.warn("智己-盲盒验证，请求失败，uid:{},blindBoxId:{},goodsId:{}", uid,blindBoxId,goodsId);
            return false;
        }
        // 智己
        String responseStr = zhiJiRequest(httpPost);
        if (StringUtils.isBlank(responseStr)) {
            log.warn("智己-盲盒验证，智己响应失败，param:{}", responseStr);
            return false;
        }
        // 判断返回
        ZhiJiBlindBoxResponse zhiJiResponse = JSONObject.parseObject(responseStr, ZhiJiBlindBoxResponse.class);
        return zhiJiResponse !=null && zhiJiResponse.getData() != null && Objects.equals(1,zhiJiResponse.getData().getCheckStatus());
    }

    private String zhiJiRequest(HttpUriRequest httpRequest) {
        try(final CloseableHttpResponse response = httpClient.execute(httpRequest)) {
            // 响应参数
            String responseStr = EntityUtils.toString(response.getEntity());
            log.info("智己-智己响应参数，param:{}", responseStr);
            return responseStr;
        } catch (Exception e) {
            log.warn("智己-智己响应异常，url:{},param:{}",httpRequest.getURI().getPath(), JSON.toJSONString(httpRequest), e);
        }
        return null;
    }


    @Override
    public void notifyBlindBoxWriteOff(ZhiJiBlindBoxRequest request) {
        // 盲盒通知
        HttpPost httpPost = zhiJiParamTool.createHttpPost(request, zhiJiConfig.getNotifyBlindBoxUrl(),zhiJiConfig.getDomainName());
        if (httpPost == null) {
            log.warn("智己-盲盒核销通知，请求失败，param:{}", JSON.toJSONString(request));
            return;
        }
        // 智己请求
        zhiJiRequest(httpPost);
    }
    @Override
    public JSONObject queryOrderAddress(List<String> orderIds) {
        Map<String, Object> params = new HashMap<>();
        params.put("timestamp", System.currentTimeMillis());
        params.put("orderNumList", Joiner.on(",").join(orderIds));
        params.put("sourceCode", SOURCE);
        params.put("traceId", System.currentTimeMillis() + StringUtils.EMPTY + RandomUtils.nextInt(100000, 999999));
        Map<String, Object> body = new HashMap<>();
        body.put("body", params);
        HttpPost httpPost = zhiJiParamTool.createHttpPost(body,zhiJiConfig.getQueryOrderAddressListUrl(),zhiJiConfig.getDomainName());
        if (httpPost == null) {
            log.warn("智己-批量查询收货地址，请求失败，param:{}", JSON.toJSONString(orderIds));
            return null;
        }
        // 智己请求
        String responseStr = zhiJiRequest(httpPost);
        if (StringUtils.isBlank(responseStr)) {
            log.warn("智己-批量查询收货地址，智己响应失败，param:{}", responseStr);
            return null;
        }
        ZhiJiResponse zhiJiResponse = JSONObject.parseObject(responseStr, ZhiJiResponse.class);
        // 智己侧响应失败
        if (ZhiJiStatusEnum.FAIL.getCode().equals(zhiJiResponse.getStatus()) || !ZhiJiCodeEnum.SUCCESS.getCode().equals(zhiJiResponse.getCode())) {
            log.warn("智己-批量查询收货地址，智己响应失败，param:{}", responseStr);
            return null;
        }
        return JSONObject.parseObject(zhiJiResponse.getData().toString());
    }

    @Override
    public JSONObject insertWebOrderExpress(Map<String, Object> params) {
        params.put("sourceCode","DUIBA");
        params.put("traceId",params.get("orderNum") + zhiJiParamTool.generateRandom());
        params.put("timestamp", System.currentTimeMillis());
        Map<String,Object> body = new HashMap<>(1);
        body.put("body", params);
        HttpPost httpPost = zhiJiParamTool.createHttpPost(body,zhiJiConfig.getInsertWebOrderExpressUrl(),zhiJiConfig.getDomainName());
        if (httpPost == null) {
            log.warn("智己-推送退货物流信息，请求失败，param:{}", JSON.toJSONString(body));
            return null;
        }
        // 智己请求
        String responseStr = zhiJiRequest(httpPost);
        if (StringUtils.isBlank(responseStr)) {
            log.warn("智己-推送退货物流信息，智己响应失败，param:{}", responseStr);
            return null;
        }
        ZhiJiResponse zhiJiResponse = JSONObject.parseObject(responseStr, ZhiJiResponse.class);
        // 智己侧响应失败
        if (ZhiJiStatusEnum.FAIL.getCode().equals(zhiJiResponse.getStatus()) || !ZhiJiCodeEnum.SUCCESS.getCode().equals(zhiJiResponse.getCode())) {
            log.warn("智己-推送退货物流信息，智己响应失败，param:{}", responseStr);
            return null;
        }
        return JSON.parseObject(responseStr);
    }

    @Override
    public void pushMsg(String nickname, String itemName, String uid, String status) {
        Map<String, Object> params = new HashMap<>();
        params.put("receiverId", uid);
        JSONObject parameters = new JSONObject();
        parameters.put("nickname", nickname);
        parameters.put("itemName", itemName);
        params.put("parameters", parameters);
        params.put("callOrigin", SOURCE);
        HttpPost httpPostOne;
        //到时候站内信开通了，可以直接去掉注释直接用
//        HttpPost httpPostTwo;
        if (StringUtils.equals(status, "false")) {
            params.put("templateId", zhiJiConfig.getFalseTmplateId().get(0));
            httpPostOne = zhiJiParamTool.createHttpPost(params,zhiJiConfig.getPushMessageUrl(),zhiJiConfig.getDomainName());
//            params.put("templateId", FALSE_TEMPLATEID.get(1));
//            httpPostTwo = zhiJiParamTool.createHttpPost(params,zhiJiConfig.getPushMessageUrl(),zhiJiConfig.getDomainName());
        } else if (StringUtils.equals(status, "ship")) {
            params.put("templateId", zhiJiConfig.getShipTmplateId().get(0));
            httpPostOne = zhiJiParamTool.createHttpPost(params,zhiJiConfig.getPushMessageUrl(),zhiJiConfig.getDomainName());
//            params.put("templateId", SHIP_TEMPLATEID.get(1));
//            httpPostTwo = zhiJiParamTool.createHttpPost(params,zhiJiConfig.getPushMessageUrl(),zhiJiConfig.getDomainName());
        } else if (StringUtils.equals(status, "recevied")) {
            params.put("templateId", zhiJiConfig.getReceviedTmplateId().get(0));
            httpPostOne = zhiJiParamTool.createHttpPost(params,zhiJiConfig.getPushMessageUrl(),zhiJiConfig.getDomainName());
//            params.put("templateId", RECEVIED_TEMPLATEID.get(1));
//            httpPostTwo = zhiJiParamTool.createHttpPost(params,zhiJiConfig.getPushMessageUrl(),zhiJiConfig.getDomainName());
        } else {
            return;
        }
        if (httpPostOne == null) {
            log.warn("智己-消息推送，请求失败，nickName:{},itemName:{},uid:{}", nickname,itemName,uid);
            return;
        }
        // 智己请求
        zhiJiRequest(httpPostOne);
//        zhiJiRequest(httpPostTwo);
    }

    @Override
    public ZhiJiProtocolResponse getProtocolById(String protocolId) {
        //todo 版本协议号存consumerext
        Map<String,Object> params =  new HashMap<>(1);
        params.put("protocolId", protocolId);
        HttpPost httpPost = zhiJiParamTool.createHttpPost(params, zhiJiConfig.queryProtocolUrl,zhiJiConfig.getDomainName());
        httpPost.setHeader("x-transaction-id",System.currentTimeMillis() + zhiJiParamTool.generateRandom());
        // 智己请求
        String responseStr = zhiJiRequest(httpPost);
        if (StringUtils.isBlank(responseStr)) {
            log.warn("智己-查询隐私协议，智己响应失败，param:{}", responseStr);
            return null;
        }
        ZhiJiResponse zhiJiResponse = JSONObject.parseObject(responseStr, ZhiJiResponse.class);
        // 智己侧响应失败
        if (!ZhiJiCodeEnum.SUCCESS_1.getCode().equals(zhiJiResponse.getCode())) {
            log.warn("智己-查询隐私协议，智己响应失败，param:{}", responseStr);
            return null;
        }
        return JSON.parseObject(JSON.toJSONString(zhiJiResponse.getData()), ZhiJiProtocolResponse.class);
    }

    @Override
    public Double getProtocolVersion(String accessToken) {
        Map<String,Object> params = new HashMap<>();
        params.put("accessToken", accessToken);
        params.put("protocolId", "YS00001");
        HttpPost httpPost = zhiJiParamTool.createHttpPost(params, zhiJiConfig.getProtocolVersionUrl,zhiJiConfig.getDomainName());
        httpPost.setHeader("x-transaction-id",System.currentTimeMillis() + zhiJiParamTool.generateRandom());
        // 智己请求
        String responseStr = zhiJiRequest(httpPost);
        if (StringUtils.isBlank(responseStr)) {
            log.warn("智己-查询隐私协议版本，智己响应失败，param:{}", responseStr);
            return null;
        }
        ZhiJiResponse zhiJiResponse = JSONObject.parseObject(responseStr, ZhiJiResponse.class);
        // 智己侧响应失败
        if (!ZhiJiCodeEnum.SUCCESS_1.getCode().equals(zhiJiResponse.getCode())) {
            log.warn("智己-查询隐私协议版本，智己响应失败，param:{}", responseStr);
            return null;
        }
        return JSON.parseObject(JSON.toJSONString(zhiJiResponse.getData())).getDouble("version");
    }

    @Override
    public Boolean signProtocol(ZhiJiSignProtocolRequest request) {
        HttpPost httpPost = zhiJiParamTool.createHttpPost(request, zhiJiConfig.signProtocolUrl,zhiJiConfig.getDomainName());
        httpPost.setHeader("x-transaction-id",System.currentTimeMillis() + zhiJiParamTool.generateRandom());
        // 智己请求
        String responseStr = zhiJiRequest(httpPost);
        if (StringUtils.isBlank(responseStr)) {
            log.warn("智己-签署隐私协议，智己响应失败，param:{}", responseStr);
            return false;
        }
        ZhiJiResponse zhiJiResponse = JSONObject.parseObject(responseStr, ZhiJiResponse.class);
        // 智己侧响应失败
        if (!ZhiJiCodeEnum.SUCCESS_1.getCode().equals(zhiJiResponse.getCode())) {
            log.warn("智己-签署隐私协议，智己响应失败，param:{}", responseStr);
            return false;
        }
        return true;
    }
}
