package cn.com.duiba.service.virtual.impl;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.client.FuLuClient;
import cn.com.duiba.constant.VirtualFuLuConfig;
import cn.com.duiba.constant.nongzonghang.FuLuConfig;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.dto.fulu.FuLuBaseReq;
import cn.com.duiba.dto.fulu.FuLuBaseResp;
import cn.com.duiba.dto.fulu.req.OrderDirectAddReq;
import cn.com.duiba.service.impl.AbstractDuibaVirtualSupplier;
import cn.com.duiba.thirdparty.dto.SupplierRequestDto;
import cn.com.duiba.thirdparty.enums.virtual.VirtualItemChannelEnum;
import cn.com.duiba.tool.fulu.FuLuUtils;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @author qiurenjie
 * @date 2021-07-16 15:00
 */
@Service
public class FuLuApiStrategy extends AbstractDuibaVirtualSupplier {

    private static final Logger LOGGER = LoggerFactory.getLogger(FuLuApiStrategy.class);
    private static final String LOGGER_PREFIX = "福禄虚拟商品接口";

    @Autowired
    private FuLuClient fuLuClient;
    @Autowired
    private VirtualFuLuConfig virtualFuLuConfig;
    @Autowired
    private AppDAO appDAO;

    private static final String Error4ConsumerMessage = "出了点小问题，请重新下单";

    @Override
    public String getVirtualTypeCode() {
        return VirtualItemChannelEnum.FULU.getCode();
    }

    @Override
    public HttpRequestBase getVirtualRequest(SupplierRequestDto supplierRequest) {
        LOGGER.info(LOGGER_PREFIX + ",request={}", JSON.toJSONString(supplierRequest));
        //将请求URL的参数转换为MAP
        Map<String, String> params = supplierRequest.getParams();
        String goodsNum = params.get("bizParams");
        //兑吧订单号
        String orderNum = params.get("orderNum");
        //用户兑换虚拟商品时输入的账号
        String account = params.get("account");

        AppDO appDO = appDAO.getAppByCache(Long.valueOf(supplierRequest.getAppId()));
        Object appConfig = virtualFuLuConfig.getAppConfigBySubjectMap().get(String.valueOf(appDO.getSubject()));
        if (Objects.isNull(appConfig)) {
            throw new ThirdpatyException("配置异常");
        }
        JSONObject appConfigJson = (JSONObject) appConfig;
        String appKey = appConfigJson.getString("appKey");
        String appSecret = appConfigJson.getString("appSecret");

        HttpPost httpPost = new HttpPost(virtualFuLuConfig.getUrl());
        //拼装请求
        FuLuConfig fuLuConfig = new FuLuConfig();
        fuLuConfig.setAppKey(appKey);

        FuLuBaseReq fuLuBaseReq = new FuLuBaseReq(fuLuConfig, FuLuConfig.Api.ORDER_DIRECT_ADD.getMethodName());
        OrderDirectAddReq orderDirectAddReq = new OrderDirectAddReq();
        orderDirectAddReq.setProductId(Long.valueOf(goodsNum));
        orderDirectAddReq.setCustomerOrderNo(orderNum);
        orderDirectAddReq.setChargeAccount(account);
        orderDirectAddReq.setBuyNum(1);
        fuLuBaseReq.setBizContent(FuLuUtils.toJSON(orderDirectAddReq));
        fuLuBaseReq.setSign(null);
        fuLuBaseReq.setSign(FuLuUtils.sign(appSecret, fuLuBaseReq));

        StringEntity stringEntity = new StringEntity(FuLuUtils.toJSON(fuLuBaseReq), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity(stringEntity);
        return httpPost;
    }

    @Override
    public String getVirtualResponse(SupplierRequestDto request, String body) {
        LOGGER.info(LOGGER_PREFIX + ",请求返回结果处理,request:{},body:{}", JSONObject.toJSONString(request), body);
        SupplierRequest supplierRequest = BeanUtils.copy(request, SupplierRequest.class);

        Map<String, String> duibaDoc = new HashMap<>();
        try {
            FuLuBaseResp fuluBaseResp = JSON.parseObject(body, FuLuBaseResp.class);
            duibaDoc = fuLuClient.getDuibaVirtualResponse(supplierRequest, fuluBaseResp, null, null, null);
        } catch (Exception e) {
            LOGGER.error("fulu，充值商品定制，结果解析错误:{}", body, e);
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", "福禄直充响应解析错误");
        }

        return JSONObject.toJSONString(duibaDoc);
    }

    @Override
    public String getDefaultError4ConsumerMessage() {
        return Error4ConsumerMessage;
    }

}
