package cn.com.duiba.tool;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Map;

/**
 * Created by xutao on 2017/7/3.
 */
public class ParserUtil {
    private static final Logger log = LoggerFactory.getLogger(ParserUtil.class);

    /**
     * 将 attributes 转换为 kv 的 Map
     * @param attributes 用;分隔的键值对 如 linkType:1;linkStr:2
     * @return
     */
    @SuppressWarnings("unchecked")
	public static Map<String, String> parseAttr2KVMap(String attributes){
        /**
         * 将attributes 中的键值对提取到kvMap中
         */
        Map<String, String> kvMap = Maps.newHashMap();

        if (StringUtils.isBlank(attributes)) {
            return kvMap;
        }
        kvMap = JSON.toJavaObject(JSON.parseObject(attributes), Map.class);
        return kvMap;
    }

    /**
     * Json解析
     * @param jsonContent 要解析的内容
     * @param clazz 要解析成的目标类
     * @param <T>
     * @return
     */
    public static <T> List<T> parseJson(String jsonContent, Class<T> clazz) {
        List<T> list = Lists.newArrayList();
        try {
            if(StringUtils.isNotBlank(jsonContent)){
                list = JSON.parseArray(jsonContent, clazz);
            }

        } catch (Exception e) {
            log.error("[ParserUtill-parseJson]jsonContent:"+jsonContent, e);
        }
        return list;
    }
}
