package cn.com.duiba.tool.cgb;

import java.io.File;

/**
 * 生成duiba公钥和私钥方式。
 * 生成的公钥后需要给到广发中心进行配置。
 */
public class SM2GenKey {

	public static void main(String[] args) throws Exception {
		String keyName="duiba";
		KeyGen(keyName);
	}


	private static void KeyGen(String merName) throws Exception {
		SM2KeyPair keyPair=SM2Util.generateKeyPair();

		File dir = new File("cert/" + merName);
		if (!dir.exists()) {
			System.out.println("是否生成目录：" + dir.mkdirs());
		}

		FileHelper.write("cert/" + merName + "/" + merName + ".pvk",
				keyPair.getPriByte());
		FileHelper.write("cert/" + merName + "/" + merName + ".puk",
				keyPair.getPubByte());
				
		System.out.println("密钥生成成功：" + merName);
	}
}
