package cn.com.duiba.tool.sn;

import cn.com.duiba.dto.sn.SnbRequestParam;
import cn.com.duiba.service.KeyMetadata;


public class SnbSignUtil {

    public static String ENV = "";
    public static SignatureVerifier VERIFIER =  new SignatureVerifier();
    public static KeyMetadata keyMetadata;

    /**
     *
     * @param appCode     苏宁银行
     * @param channelId
     */
    public static void initApi(String appCode, String channelId) {
        SnbRequestParam.setAppCode(appCode);
        // 苏宁银行分配给商户的渠道编号
        SnbRequestParam.setChannelId(channelId);
        // 从默认路径加载苏宁银行公钥
        SnbUtil.loadSnbPublicKey();
    }

    public static void setEnv(InitData.ENV env){
        switch (env){
            case sit:
                SnbSignUtil.ENV = "sit";
                break;
            case uat:
                SnbSignUtil.ENV = "uat";
                break;
            case prd:
                SnbSignUtil.ENV = "";
                break;
            default:
                break;
        }
    }

    public static String getSnbPublicKeyPath() {
        String snbPublicKeyPath = "/bankKey/"+"SnbPublicKey" + SnbSignUtil.ENV  + ".cer";
        return snbPublicKeyPath;
    }

    /**
     * @param keyStorePwd
     * @param keyPwd
     * @param merPrivatePath 商户端的私钥证书所在的文件夹绝对路径，如果入参为Null,则取默认路径。
     *        （不包含文件名。如您证书所在位置为'/temp/file/MerPriKey.pfx'，传入'/temp/file/'）。
     */
    public static void setKeyMetadata(String keyStorePwd, String keyPwd, String merPrivatePath) {
        if(merPrivatePath == null){
            merPrivatePath = InitData.MerPriKeyPath;
        }
        if(!merPrivatePath.endsWith("/")){
            merPrivatePath += "/";
        }
        merPrivatePath = merPrivatePath + "MerPriKey" + SnbSignUtil.ENV + ".pfx";
        SnbSignUtil.keyMetadata = new KeyMetadata("1", merPrivatePath, keyStorePwd, null, keyPwd);
    }
}
