package cn.com.duiba.tool.sn;

import cn.com.duiba.dto.sn.PayLoadParam;
import cn.com.duiba.dto.sn.SnbRequestParam;
import cn.com.duiba.service.Encryptor;
import cn.com.duiba.service.KeyMetadata;
import cn.com.duiba.service.KeyRegistry;
import cn.com.duiba.service.impl.AESEncryptor;
import cn.com.duiba.service.impl.KeyRegistryImpl;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class SnbUtil {
    private static final Logger log = LoggerFactory.getLogger(SnbUtil.class);

    public static Encryptor AESENCRYPTOR = new AESEncryptor();
    public static KeyRegistry KEYREGISTRY = new KeyRegistryImpl();
    public static SignatureSigner SIGNATURESIGNER = new SignatureSigner();
    public static SignatureVerifier SIGNATUREVERIFIER = new SignatureVerifier();

    // 苏宁银行公钥
    public static PublicKey snbPublicKey = null;

    public static String encyptRandomNum(String randomNum) {
        byte[] secretKeyBytes = AESENCRYPTOR.encrypt("RSA", randomNum.getBytes(), SnbUtil.snbPublicKey);
        return Hex.toHex(secretKeyBytes);
    }

    /**
     * 获取堆成秘钥
     */
    public static String genRandomNum() {
        Random random = new SecureRandom();
        StringBuffer randomKey = new StringBuffer();
        for (int i = 0; i < 18; i++) {
            randomKey = randomKey.append(new Integer(random.nextInt(9)).toString());
        }
        return randomKey.toString();
    }

    public static Map<String,String> sendDataToSNB(Map<String,String> dataMap, PayLoadParam payLoad, String rand, KeyMetadata keyMetadata) throws JsonProcessingException, UnsupportedEncodingException {
        Map payloadMap = bean2Map(payLoad);
        // 业务数据转成json后使用randomNum加密
        String payloadJson = InitData.OBJECTMAPPER.writeValueAsString(payloadMap);
        String payload = encyptPayload(payloadJson, rand);

        // 组装签名原文所需的数据
        Map plainMap = new HashMap();
        plainMap.putAll(dataMap);
        plainMap.putAll(payloadMap);

        // 生成签名原文plain 并使用商户私钥获签名
        String plain = Permutation.sort(plainMap, InitData.CHARSET_UTF8);
//        log.info("plain:[" + plain + "]");
        String signature = sign(plain, InitData.Algorithm, keyMetadata);

        // 将业务数据加密后的结果和签名值存放到请求报文中
        dataMap.put("payload", payload);
        dataMap.put("signature", signature);

        return dataMap;
    }

    public static Map extendMap(Map respMap) throws JsonParseException, JsonMappingException, IOException {
        String respCode = (String) respMap.get("respCode");
        if ("00000000".equals(respCode)) {
            String respPayload = (String) respMap.get("payload");
            String respSecretKey = (String) respMap.get("secretKey");
            String respSignature = (String) respMap.get("signature");

            Map respPlainMap = new HashMap();
            respPlainMap.putAll(respMap);
            respPlainMap.remove("payload");
            respPlainMap.remove("signature");

            // 使用商户私钥解密对称秘钥获取到randomNum
            String respRandomNum = decodeSecretKey(respSecretKey, (PrivateKey) KEYREGISTRY.getKey(SnbSignUtil.keyMetadata));
            Map respPayloadMap = decyptPayload(respPayload, respRandomNum);// 业务数据的map值

            respPlainMap.putAll(respPayloadMap);
            String respPlain = Permutation.sort(respPlainMap, InitData.CHARSET_UTF8);
            log.info("返回报文的签名原文：[" + respPlain + "]");

            boolean verifyRes = verify(respPlain, respSignature, InitData.Algorithm, SnbUtil.snbPublicKey);
            if (verifyRes) {
                respPlainMap.put("verifyRes", true);
            } else {
                respPlainMap.put("verifyRes", false);
            }
            respPlainMap.put("respPlain", respPlain );
            return respPlainMap;
        } else {
            log.info("respCode[" + respCode + "]");
            return respMap;
        }
    }

    public static String encyptPayload(String payloadJson, String randomNum) {
        byte[] enOut = SMS4Util.encodeSMS4(payloadJson, randomNum.getBytes());
        String payloadEncrypt = Hex.toHex(enOut);
        return payloadEncrypt;
    }

    public static Map decyptPayload(String payload, String randomNum)
            throws IOException {
        String deOut = SMS4Util.decodeSMS4toString(Hex.toByte(payload), randomNum.getBytes());
        System.out.println("payload==json str===" + deOut);
        return InitData.OBJECTMAPPER.readValue(deOut, Map.class);
    }

    public static String sign(String plain, String algorithm, KeyMetadata keyMetadata) {
        Key privatekey = KEYREGISTRY.getKey(keyMetadata);
        return SIGNATURESIGNER.sign(plain, algorithm, (PrivateKey) privatekey);
    }

    public static String decodeSecretKey(String secretKey, PrivateKey privateKey) {
        byte[] decodedData = AESENCRYPTOR.decrypt("RSA", Hex.toByte(secretKey), privateKey);
        String decodedKey = new String(decodedData);
        return decodedKey;
    }

    public static boolean verify(String plain, String signature, String algorithm, PublicKey publicKey) {
        return SIGNATUREVERIFIER.verify(plain, signature, algorithm, publicKey);
    }

    public static String getTimestamp() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date(System.currentTimeMillis()));
    }

    /**
     *  返回发送到苏宁方的交易数据
     */
    public static Map<String, String> send(SnbRequestParam snbRequestDto) throws Exception{

        String rand = SnbUtil.genRandomNum();
        // 组装请求报文， 注意：值为空的字段不要往map中设置
        Map<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("appCode", snbRequestDto.getAppCode());// 应用编号
        dataMap.put("channelSerialNo", snbRequestDto.getChannelSerialNo());// 流水号
        dataMap.put("timestamp", SnbUtil.getTimestamp());// 时间戳
        dataMap.put("algorithm", InitData.Algorithm);
        dataMap.put("channelId", snbRequestDto.getChannelId());
        dataMap.put("secretKey", SnbUtil.encyptRandomNum(rand));// 随机秘钥
        dataMap.put("transCode", snbRequestDto.getTransCode());// 交易码

        // 以下为非必输字段
        if(!isEmpty(snbRequestDto.getDeviceId())){
            dataMap.put("deviceId", snbRequestDto.getDeviceId());
        }
        if(!isEmpty(snbRequestDto.getTerminal())) {
            dataMap.put("terminal", snbRequestDto.getTerminal());
        }
        if(!isEmpty(snbRequestDto.getGps())) {
            dataMap.put("gps", snbRequestDto.getGps());
        }
        if(!isEmpty(snbRequestDto.getIpAddress())) {
            dataMap.put("ipAddress", snbRequestDto.getIpAddress());
        }
        if(!isEmpty(snbRequestDto.getMacAddress())) {
            dataMap.put("macAddress", snbRequestDto.getMacAddress());
        }
        if(!isEmpty(snbRequestDto.getOsVersion())) {
            dataMap.put("osVersion", snbRequestDto.getOsVersion());
        }
        if(!isEmpty(snbRequestDto.getOpenId())) {
            dataMap.put("openId", snbRequestDto.getOpenId());
        }
        return SnbUtil.sendDataToSNB(dataMap, snbRequestDto.getPayLoad(), rand, SnbSignUtil.keyMetadata);
    }


    public static Map<String, Object> bean2Map(Object beanObject) {
        BeanWrapperImpl bean = new BeanWrapperImpl(beanObject);
        PropertyDescriptor[] desc = bean.getPropertyDescriptors();
        Map<String, Object> dataMap = new HashMap<String, Object>(desc.length);
        try {
            for (int i = 0; i < desc.length; ++i) {
                String name = desc[i].getName();

                if ((!(bean.isWritableProperty(name))) || (!(bean.isReadableProperty(name))))
                    continue;
                Object object = bean.getPropertyValue(name);
                if (object == null) {
                    continue;
                }
                dataMap.put(name, object);
            }

            return dataMap;
        } catch (Exception e1) {
            throw e1;
        }
    }

    /**
     *  加载苏宁银行公钥
     */
    public static PublicKey loadSnbPublicKey(){
        if(SnbUtil.snbPublicKey != null){
            return  SnbUtil.snbPublicKey;
        }
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate) cf.generateCertificate(SnbUtil.class.getResourceAsStream(SnbSignUtil.getSnbPublicKeyPath()));
            SnbUtil.snbPublicKey = cert.getPublicKey();
            return cert.getPublicKey();
        } catch (Exception e) {
            log.error("", e);
            return null;
        }
    }

    public static boolean isEmpty(String str){
        return str == null || str.isEmpty();
    }
}
