package cn.com.duiba.biz.credits;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.net.URLDecoder;
import java.util.Map;

/**
 * @author qianjue
 * @date 2019/6/17
 * @description: 平安壹钱包定制逻辑处理类
 */
@Service
public class PayqbApi {

    private Logger logger = LoggerFactory.getLogger(PayqbApi.class);
    /**
     * 扣积分请求方式为POST请求
     * @param request
     * @return
     */
    public CreditsMessage getSubCreditsMessage(CreditsMessage request) {
        String url = request.getHttpUrl();
        //post请求,截取出url去除参数的部分,设置为请求url
        String host = url.substring(0, url.indexOf('?'));
        request.setHttpUrl(host);
        //将原get请求的参数转化成map
        String params = url.substring(url.indexOf('?') + 1, url.length());
        Map<String, String> crediMap = AssembleTool.getUrlParams(params);
        crediMap.put("postType","raw");
        crediMap.put("unicodeType","UTF-8");
        request.setAuthParams(crediMap);
        request.setHttpType(CreditsMessage.HTTP_POST);
        return request;
    }


    public SubCreditsMsgWrapper getRequestCredits(SubCreditsMsgWrapper subCreditsMsgWrapper) {
        String url = subCreditsMsgWrapper.getHttpUrl();
        //post请求,截取出url去除参数的部分,设置为请求url
        String host = url.substring(0, url.indexOf('?'));
        subCreditsMsgWrapper.setHttpUrl(host);
        String params = url.substring(url.indexOf('?') + 1, url.length());
        Map<String, String> authPqrams = AssembleTool.getUrlParams(params);
        authPqrams.put("postType","raw");
        authPqrams.put("unicodeType","UTF-8");
        subCreditsMsgWrapper.getSubCreditsMsg().setAuthParams(authPqrams);
        subCreditsMsgWrapper.getSubCreditsMsg().setHttpType(SubCreditsMsgDto.HTTP_POST);
        return subCreditsMsgWrapper;
    }

    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request) {
        String url = request.getHttpUrl();
        //post请求,截取出url去除参数的部分,设置为请求url
        String host = url.substring(0, url.indexOf('?'));
        request.setHttpUrl(host);
        //将原get请求的参数转化成map
        String params = url.substring(url.indexOf('?') + 1, url.length());
        Map<String, String> authParams = AssembleTool.getUrlParams(params);
        authParams.put("postType","raw");
        authParams.put("unicodeType","UTF-8");
        request.setAuthParams(authParams);
        request.setHttpType(CreditsMessage.HTTP_POST);
        return request;
    }

    public SupplierRequest getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        //post请求,截取出url去除参数的部分,设置为请求url
        String host = url.substring(0, url.indexOf('?'));
        request.setHttpUrl(host);
        //将原get请求的参数转化成map
        String params = url.substring(url.indexOf('?') + 1, url.length());
        Map<String, String> authParams = AssembleTool.getUrlParams(params);
        authParams.put("postType","raw");
        authParams.put("unicodeType","UTF-8");
        request.setAuthParams(authParams);
        return request;
    }

    public String parseCrditsRsp(String body){
        try{
            String bodyTemp = URLDecoder.decode(body,"utf-8");
            return bodyTemp;
        }catch (Exception e){
            logger.info("PayqbApi parseCrditsRsp error,boby is {}",body,e);
            return body;
        }
    }
}
