package cn.com.duiba.biz.credits.nongzonghang;

import cn.com.duiba.constant.nongzonghang.FuLuConfig;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.domain.SupplierResponse;
import cn.com.duiba.domain.VirtualSupplierProcessingOrderLogEntity;
import cn.com.duiba.dto.fulu.FuLuBaseReq;
import cn.com.duiba.dto.fulu.FuLuBaseResp;
import cn.com.duiba.dto.fulu.req.OrderDirectAddReq;
import cn.com.duiba.dto.fulu.resp.OrderDirectAddResp;
import cn.com.duiba.dto.virtualsupplierprocess.MqInfo;
import cn.com.duiba.service.ThreadPoolService;
import cn.com.duiba.service.virtualsupplierprocess.VirtualSupplierProcessOrderService;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.fulu.FuLuUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

/**
 * 福禄定制
 *
 * @author haojiahong
 * @date 2020-07-20
 */
@Service
public class FuLuApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(FuLuApi.class);
    private static Set<Integer> UNUSUAL_CODE = Sets.newHashSet(4008, 4009, 4010, 4012, 5000);

    @Autowired
    private FuLuConfig fuluConfig;
    @Autowired
    private VirtualSupplierProcessOrderService virtualSupplierProcessOrderService;
    @Autowired
    private ThreadPoolService threadPoolService;

    /**
     * 农总行下，特殊appItemId走福禄定制
     *
     * @param message
     * @return
     */
    public Boolean isFuLu4NongZongHang(SupplierRequest message) {
        Map<Long, String> map = fuluConfig.getAppItemProductMap();
        if (MapUtils.isEmpty(map)) {
            return false;
        }
        String appItemIdStr = message.getParams().get("appItemId");
        if (StringUtils.isBlank(appItemIdStr)) {
            return false;
        }
        Long appItemId = Long.valueOf(appItemIdStr);
        if (!map.keySet().contains(appItemId)) {
            return false;
        }
        return true;
    }


    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        Long appItemId = Long.valueOf(request.getParams().get("appItemId"));
        String productId = fuluConfig.getAppItemProductMap().get(appItemId);
        String url = request.getHttpUrl();
        String paramsStr = url.substring(url.indexOf('?') + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        //兑吧订单号
        String orderNum = params.get("orderNum");
        //用户兑换虚拟商品时输入的账号
        String account = params.get("account");
        String goodsNum = params.get("params");
        request.setAuthParams(params);

        HttpPost httpPost = new HttpPost(fuluConfig.getUrl());
        //拼装请求
        FuLuBaseReq fuLuBaseReq = new FuLuBaseReq(fuluConfig, FuLuConfig.Api.ORDER_DIRECT_ADD.getMethodName());
        OrderDirectAddReq orderDirectAddReq = new OrderDirectAddReq();
        orderDirectAddReq.setProductId(Long.valueOf(productId));
        orderDirectAddReq.setCustomerOrderNo(orderNum);
        orderDirectAddReq.setChargeAccount(account);
        orderDirectAddReq.setBuyNum(1);
        fuLuBaseReq.setBizContent(FuLuUtils.toJSON(orderDirectAddReq));
        fuLuBaseReq.setSign(null);
        fuLuBaseReq.setSign(FuLuUtils.sign(fuluConfig.getSysSecret(), fuLuBaseReq));

        StringEntity stringEntity = new StringEntity(FuLuUtils.toJSON(fuLuBaseReq), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity(stringEntity);
        return httpPost;
    }

    public String getVirtualResponse(SupplierRequest message, String body, String callbackTopic, String msgTag, String msgKey) {
        Map<String, String> duibaDoc = new HashMap<>();
        try {
            FuLuBaseResp fuluBaseResp = JSON.parseObject(body, FuLuBaseResp.class);
            duibaDoc = this.getDuibaVirtualResponse(message, fuluBaseResp, callbackTopic, msgTag, msgKey);
        } catch (Exception e) {
            LOGGER.error("fulu，充值商品定制，结果解析错误:{}", body, e);
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", "福禄直充响应解析错误");
        }
        return JSON.toJSONString(duibaDoc);
    }

    private Map<String, String> getDuibaVirtualResponse(SupplierRequest message, FuLuBaseResp fuluBaseResp, String callbackTopic, String msgTag, String msgKey) {
        Map<String, String> duibaDoc = new HashMap<>();
        //请求成功
        if (Objects.equals(fuluBaseResp.getCode(), 0)) {
            OrderDirectAddResp orderDirectAddResp = JSON.parseObject(fuluBaseResp.getResult(), OrderDirectAddResp.class);
            //下单成功
            if (StringUtils.equals(orderDirectAddResp.getOrderState(), "success")) {
                duibaDoc.put("status", "success");
                duibaDoc.put("supplierBizId", orderDirectAddResp.getOrderId());
                return duibaDoc;
            }
            //下单失败
            if (StringUtils.equals(orderDirectAddResp.getOrderState(), "failed")) {
                LOGGER.warn("fulu，下单失败，resp=={}", JSON.toJSONString(fuluBaseResp));
                duibaDoc.put("status", "fail");
                duibaDoc.put("errorMessage", "出了点小问题，请重新下单");
                return duibaDoc;
            }
            //订单未处理或处理中，记录中间状态记录表，发送消息时，会先查询中间状态记录表，如有，会之后通过定时任务轮询订单状态发送消息。
            if (StringUtils.equals(orderDirectAddResp.getOrderState(), "untreated")
                    || StringUtils.equals(orderDirectAddResp.getOrderState(), "processing")) {
                threadPoolService.submit(() -> initSave(message, callbackTopic, msgTag, msgKey));
                duibaDoc.put("status", "need-repeat-query");
                return duibaDoc;
            }
        }
        //特殊code，订单进入异常订单
        else if (UNUSUAL_CODE.contains(fuluBaseResp.getCode())) {
            duibaDoc.put("status", "unusual");
            duibaDoc.put("errorMessage", fuluBaseResp.getMessage());
            return duibaDoc;
        }
        //其他情况：下单失败
        else {
            LOGGER.warn("fulu，下单失败，resp=={}", JSON.toJSONString(fuluBaseResp));
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", "出了点小问题，请重新下单");
            return duibaDoc;
        }
        return duibaDoc;
    }

    private void initSave(SupplierRequest message, String callbackTopic, String msgTag, String msgKey) {
        VirtualSupplierProcessingOrderLogEntity entity = new VirtualSupplierProcessingOrderLogEntity();
        entity.setAppId(Long.valueOf(message.getAppId()));
        entity.setConsumerId(Long.valueOf(message.getConsumerId()));
        entity.setOrderId(Long.valueOf(message.getOrderId()));
        entity.setOrderNum(message.getParams().get("orderNum"));
        entity.setSupplierOrderId(Long.valueOf(message.getSupplierOrderId()));
        entity.setSupplierName(message.getSupplierName());
        entity.setHttpUrl(message.getHttpUrl());
        MqInfo mqInfo = new MqInfo();
        mqInfo.setMqCallbackTopic(callbackTopic);
        mqInfo.setMqTag(msgTag);
        mqInfo.setMqMsgKey(msgKey);
        entity.setMqInfo(JSON.toJSONString(mqInfo));
        virtualSupplierProcessOrderService.initSave(entity);
    }


    public boolean customFinallyBlock(SupplierResponse response) {
        if (StringUtils.isNotBlank(response.getBody())) {
            JSONObject duibaResponse = JSON.parseObject(response.getBody());
            //请求成功，订单处于未处理或处理中【订单中间状态不需要发消息，之后定时任务发消息】
            if (StringUtils.equals((String) duibaResponse.get("status"), "need-repeat-query")) {
                return false;
            }
            //请求成功，但返回状态码为需特殊处理的状态码，此类订单需进异常订单
            if (StringUtils.equals((String) duibaResponse.get("status"), "unusual")) {
                response.setCallbackType(SupplierResponse.CALLBACK_TYPE_FAILED);
            }
        }
        return true;
    }
}
