package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.config.YingdaConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.JsonTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @Date 2022/03/02
 * @Created by xph
 */
@Component
public class YingdaApiStrategy implements ApiStrategy {

    private static final Logger log = LoggerFactory.getLogger(YingdaApiStrategy.class);


    private static final String CHARACTER_ENCODE = "UTF-8";
    private static final String APPLICATION_JSON = "application/json";

    private static final String LOG_HEAD = "英大证券";

    private static final String SUCCESS = "200";

    @Autowired
    private YingdaConfig yingdaConfig;

    @Override
    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        log.info("{}扣积分开始",LOG_HEAD);
        return null;
    }

    /**
     * 解析返回结果
     * @param body   返回体    :
     * @param addCredits true加积分
     * @param authParams 订单相关参数
     * @return
     */
    @Override
    public String parseCreditsRsp(String body, Boolean addCredits, Map<String, String> authParams) {

        Map<String, String> duibaDoc = new HashMap<>();
        duibaDoc.put("bizId", authParams.get("orderNum"));
        duibaDoc.put("credits", authParams.get("credits"));
        duibaDoc.put("status","fail");
        log.info("{}积分响应体：{}",LOG_HEAD,body);
        if (addCredits){
            JSONObject jsonObject = JSONObject.parseObject(body);
            String flag = jsonObject.getString("code");
            if (SUCCESS.equals(flag)){
                duibaDoc.put("status","ok");
                JSONObject data = jsonObject.getJSONObject("data");
                if (data!=null){
                    duibaDoc.put("bizId",data.getString("log_id"));
                }
            }else {
                log.warn("{}加积分响应失败：{}",LOG_HEAD,body);
                duibaDoc.put("errorMessage",jsonObject.getString("msg"));
            }
        }
        return JsonTool.objectToJson(duibaDoc);
    }

    /**
     * 加积分接口地址：https://www.kancloud.cn/s365_xbr/api_third/2646709
     * @param message :
     * @return
     */
    @Override
    public HttpRequestBase getAddCreditsMessageRequest(CreditsMessageDto message) {
        try {
            log.info("{}加积分请求 :{}", LOG_HEAD, JSON.toJSONString(message));
            String url = message.getHttpUrl();
            String host = url.substring(0, url.indexOf('?'));
            //获取加积分的其他参数
            Map<String, String> body = buildParam(message);
            log.info("{}加积分请求参数{}", LOG_HEAD, JSONObject.toJSONString(body));
            HttpPost httpPost = new HttpPost(host);
            //构建请求头
            buildHeader(httpPost,body);
            List<NameValuePair> pairs = new ArrayList<>(body.size());
            body.entrySet().forEach(e->{
                pairs.add(new BasicNameValuePair(e.getKey(), e.getValue()));
            });
            httpPost.setEntity(new UrlEncodedFormEntity(pairs,"UTF-8"));
            return  httpPost;
        } catch (Exception e) {
            log.warn("{}加积分请求异常",LOG_HEAD,e);
        }
        return null;
    }

    /**
     * 构建请求头
     *  @param
     * @return
     */
    public void buildHeader(HttpPost httpPost,Map<String,String> body){
        TreeMap<String, String> header = new TreeMap<>();
        String time = String.valueOf(System.currentTimeMillis() / 1000);
        String randNum = String.valueOf(RandomUtils.nextInt(100000, 999999));
        header.put("appId", yingdaConfig.getDeveloperAppId());
        header.put("randNum", randNum);
        header.put("time", time);
        StringBuilder stringBuilder = new StringBuilder();
        //生成排序字符串
        String orderStr = body.entrySet().stream()
                .map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue()))
                .collect(Collectors.joining("&"));
        //生成代签名字符串
        String noSignStr = stringBuilder.append(yingdaConfig.getDeveloperAppId())
                .append(time)
                .append(randNum)
                .append(yingdaConfig.getDeveloperAppSecret())
                .append(orderStr).toString();
        String sign = DigestUtils.md5Hex(noSignStr);
        header.put("sign", sign);

        header.entrySet().forEach(e -> {
            httpPost.addHeader(e.getKey(), e.getValue());
        });
        log.info("{}加积分请求header={}", LOG_HEAD, JSONObject.toJSONString(header));
    }

    /**
     * 构建参数
     * @param messageDto
     * @return
     */
    public Map<String, String> buildParam( CreditsMessageDto messageDto){
        Map<String, String> authParams = messageDto.getAuthParams();
        TreeMap<String, String> paramMap = new TreeMap<>();

        paramMap.put("userId",authParams.get("uid"));
        paramMap.put("credit",authParams.get("credits"));
        paramMap.put("mark",authParams.get("description"));
        paramMap.put("reward",authParams.get("orderNum"));
        paramMap.put("reward_id",messageDto.getRelationId());
        return paramMap;
    }

    @Override
    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record) {
        log.info("{}获取兑换结果通知",LOG_HEAD);
        return null;
    }
}
