package cn.com.duiba.config;

import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.biz.credits.strategy.Impl.YingdaApiStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;
import java.util.HashSet;

@Configuration
@ConfigurationProperties(prefix = "yingda.config")
public class YingdaConfig implements InitializingBean {

    private static final Logger log = LoggerFactory.getLogger(YingdaConfig.class);

    /**
     * 兑吧appId
     */
    private String appId = "87149";

    /**
     * 开发者密钥
     */
    private String developerAppSecret = "qFSUyhlEUUYfHuwIFX6e269re3jqLCsN";

    /**
     * 开发者appId
     */
    private String developerAppId = "202203041014";

    @Resource
    private YingdaApiStrategy yingdaApiStrategy;

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getDeveloperAppSecret() {
        return developerAppSecret;
    }

    public void setDeveloperAppSecret(String developerAppSecret) {
        this.developerAppSecret = developerAppSecret;
    }

    public YingdaApiStrategy getYingdaApiStrategy() {
        return yingdaApiStrategy;
    }

    public void setYingdaApiStrategy(YingdaApiStrategy yingdaApiStrategy) {
        this.yingdaApiStrategy = yingdaApiStrategy;
    }

    public String getDeveloperAppId() {
        return developerAppId;
    }

    public void setDeveloperAppId(String developerAppId) {
        this.developerAppId = developerAppId;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        log.info("英大证券-开始注册策略---------APPID:{}", appId);
        HashSet<Long> appIds = new HashSet<>();
        appIds.add(Long.valueOf(appId));
        ApiStrategyRouter.register(appIds, yingdaApiStrategy);
    }
}
