package cn.com.duiba.config;

import com.google.common.collect.Sets;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Configuration;

import java.util.Set;

/**
 * @author MeiChang
 * @Description
 */
@Configuration
@RefreshScope
public class ZhongXinConfig {

    // 兑吧应用ID集合
    @Value("#{'${zhongxin.virtual.addCredits.appIds}'.split(',')}")
    private Set<Long> appIds ;

    //开放银行合作方APPID（由开放银行维护后提供）
    @Value("${zhongxin.virtual.addCredits.appId:123}")
    private String appId;

    //开放平台商户名称（由开放银行维护后提供）
    @Value("${zhongxin.virtual.addCredits.merchantName:123}")
    private String merchantName;

    //开放平台业务类型
    @Value("${zhongxin.virtual.addCredits.type:123}")
    private String type;

    //设置加密公钥，使用中信银行提供的XX合作方_发送请求时加密报文证书的公钥
    @Value("${zhongxin.virtual.addCredits.publikey:123}")
    private String reqPublikey;
    //设置加签私钥，使用合作方生成的XX合作方_发送请求时签名报文证书的私钥
    @Value("${zhongxin.virtual.addCredits.privatekey:123}")
    private String repPrivatekey;
    //设置加签私钥密码，使用合作方生成的XX合作方_发送请求时签名报文证书的私钥密码
    @Value("${zhongxin.virtual.addCredits.privatekeyPwd:123}")
    private String repPrivatekeyPwd;

    //设置接收响应时验证签名报文证书的公钥
    @Value("${zhongxin.virtual.addCredits.respPublikey:123}")
    private String respPublikey;
    //接收响应时解密报文证书的私钥
    @Value("${zhongxin.virtual.addCredits.respPrivatekey:123}")
    private String respPrivatekey;
    //接收响应时解密报文证书的私钥密码
    @Value("${zhongxin.virtual.addCredits.respPrivatekeyPwd:123}")
    private String respPrivatekeyPwd;




    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getMerchantName() {
        return merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getReqPublikey() {
        return reqPublikey;
    }

    public void setReqPublikey(String reqPublikey) {
        this.reqPublikey = reqPublikey;
    }

    public String getRepPrivatekey() {
        return repPrivatekey;
    }

    public void setRepPrivatekey(String repPrivatekey) {
        this.repPrivatekey = repPrivatekey;
    }

    public String getRepPrivatekeyPwd() {
        return repPrivatekeyPwd;
    }

    public void setRepPrivatekeyPwd(String repPrivatekeyPwd) {
        this.repPrivatekeyPwd = repPrivatekeyPwd;
    }

    public String getRespPublikey() {
        return respPublikey;
    }

    public void setRespPublikey(String respPublikey) {
        this.respPublikey = respPublikey;
    }

    public String getRespPrivatekey() {
        return respPrivatekey;
    }

    public void setRespPrivatekey(String respPrivatekey) {
        this.respPrivatekey = respPrivatekey;
    }

    public String getRespPrivatekeyPwd() {
        return respPrivatekeyPwd;
    }

    public void setRespPrivatekeyPwd(String respPrivatekeyPwd) {
        this.respPrivatekeyPwd = respPrivatekeyPwd;
    }

    public Set<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }
}
