package cn.com.duiba.constant;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Configuration;


/**
 * @Description 银联会员商品配置
 * @Date 2022/4/25
 * @Author WeiChaoChao
 */
@Configuration
@ConfigurationProperties(prefix = "union.member")
@RefreshScope
public class UnionMemberConstant {
    /**
     * 积点虚拟商品前缀
     */
    private String virtualPre = "UnionMember_";
    /**
     * 银联赠送积点请求url
     */
    private String memberSendUrl = "https://open.95516.com/open/access/1.0/memberVipAcquire";
    /**
     * 开发者业务类型对应的会员商品相关配置
     *
     * @see cn.com.duiba.vo.union.UnionMemberConfig
     */
    private String miniAppConfigs = "";

    public String getMemberSendUrl() {
        return memberSendUrl;
    }

    public void setMemberSendUrl(String memberSendUrl) {
        this.memberSendUrl = memberSendUrl;
    }

    public String getMiniAppConfigs() {
        return miniAppConfigs;
    }

    public void setMiniAppConfigs(String miniAppConfigs) {
        this.miniAppConfigs = miniAppConfigs;
    }

    public String getVirtualPre() {
        return virtualPre;
    }

    public void setVirtualPre(String virtualPre) {
        this.virtualPre = virtualPre;
    }
}
