package cn.com.duiba.dao.custom.impl;

import cn.com.duiba.constant.DatabaseSchema;
import cn.com.duiba.dao.BaseDAO;
import cn.com.duiba.dao.custom.LivatRollbackRecordDAO;
import cn.com.duiba.domain.LivatRollbackRecordDO;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Repository;

import java.util.Map;

/**
 * Created by fangdong on 2020/07/13
 */
@Repository
public class LivatRollbackRecordDAOImpl extends BaseDAO implements LivatRollbackRecordDAO {

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.DUIBA_CUSTOM;
    }


    @Override
    public Long insert(LivatRollbackRecordDO entity) {
        super.insert("insert", entity);
        return entity.getId();
    }

    public LivatRollbackRecordDO selectByOrderNum(String orderNum) {
        Map<String, Object> params = Maps.newHashMap();
        params.put("orderNum", orderNum);

        return super.selectOne("selectByOrderNum", params);
    }

    @Override
    public void updateById(LivatRollbackRecordDO entity) {
        super.update("update", entity);
    }
}
